<div class="table-wrapper">
    <table class="sortable">
        <thead>
            <tr>
                <th class="w-1 static-column">#</th>
                <th class="w-2">NAME</th>
                <th class="w-3">TOTAL BETS</th>
                <th class="w-1">WIN</th>
                <th class="w-1">LOSS</th>
                <th class="w-1">PUSH</th>
                <th class="w-3">WIN%</th>
                <th class="w-3">NET</th>
                <th class="w-3">GROUPS</th>
                <th class="w-3">LAST PICK DATE</th>
            </tr>
        </thead>
        <tbody>
            <?php $fields = $block_leader_board->getFieldsValidate(); ?>
            <?php foreach ($leaders as $key => $leader): ?>
                <?php if (!$rdgb->helpers->validateFields($fields, $leader)) continue; ?>
                <?php if (!empty($leader['rank']) && !empty($leader['name'])): ?>
                    <tr>
                        <?php $url = (isset($leader['handicapper_detail_url']) && !empty($leader['handicapper_detail_url'])) ? $leader['handicapper_detail_url'] : '#'; ?>
                        <td class="top w-1 static-column"><?php echo $leader['rank']; ?></td>
                        <td class="name w-2"><a href="<?php echo $url; ?>" target="_blank"><?php echo $leader['name']; ?></a></td>
                        <td class="w-3"><?php echo (!empty($leader['total_bets'])) ? $leader['total_bets'] : 0; ?></td>
                        <td class="w-1"><?php echo (!empty($leader['win'])) ? $leader['win'] : 0; ?></td>
                        <td class="w-1"><?php echo (!empty($leader['loss'])) ? $leader['loss'] : 0; ?></td>
                        <td class="w-1"><?php echo (!empty($leader['push'])) ? $leader['push'] : 0; ?></td>
                        <td class="w-1"><?php echo number_format($leader['win_percentaje'], 2, '.', ','); ?>%</td>
                        <td class="w-3">$<?php echo number_format($leader['net'], 0, '.', ','); ?></td>
                        <td class="w-3"><?php echo '-'; ?></td>
                        <td class="w-3"><?php echo '-' ?></td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
