<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_HANDICAPPER_PICK_RESULTS;
    $block_classes = [$block_name];
    $block_handicapper_pick_results = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $primary_date = (!empty(get_field('primary_date'))) ? get_field('primary_date') : null;
    $secondary_date = (!empty(get_field('secondary_date'))) ? get_field('secondary_date') : null;

    $sports = (!empty(get_field('sports'))) ? get_field('sports') : '';
    $handicapper = (!empty(get_field('handicapper'))) ? get_field('handicapper') : '';
    
    $source = get_field('source');

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $cache_file = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $pick_results = [];

    if ($source == 'api' && $block_handicapper_pick_results->isCaching()) {
        $api_url = get_field('handicapper_pick_results_api_url', 'option');
        $api_token = get_field('handicapper_pick_results_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_handicapper_pick_results->getApiAttributes($items, ['primary_date' => $primary_date, 'secondary_date' => $secondary_date, 'sports' => $sports, 'handicapper' => $handicapper]);

            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);

            $response = $block_handicapper_pick_results->getResources($api_attributes, $cache_file);

            if (empty($response->message) && isset($response->json['data']) && is_array($response->json['data'])) {
                $pick_results = $response->json['data'];
            } else {
                $pick_results = null;
                $message = $response->message;
            }

        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<?php if (is_array($pick_results) && count($pick_results) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
            $block_handicapper_pick_results->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="hpr-container">
            <?php
                if ($source == 'api') {
                    require 'partials/api.php';
                } else {
                    require 'partials/manual.php';
                }
            ?>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
            const rows = document.querySelectorAll(".table-row"); 
            const loadMoreBtn = document.getElementById("load-more");
            let visibleCount = 10; 

            if (!loadMoreBtn || rows.length <= 10) return; 

            loadMoreBtn.addEventListener("click", function () {
                let newVisibleCount = visibleCount + 10; 
                rows.forEach((row, index) => {
                    if (index < newVisibleCount) {
                        row.style.display = "table-row"; 
                    }
                });
                visibleCount = newVisibleCount;

                if (visibleCount >= rows.length) {
                    loadMoreBtn.style.display = "none";
                }
            });
        });
        </script>
    </div>
<?php endif; ?>