<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_LEADER_BOARD;
    $block_classes = [$block_name];
    $block_leader_board = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $titles_sports = $rdgb->helpers->get_sporst_categories_options(true);
    $date_ranges = $block_leader_board->get_leader_board_date_range();

    $category = get_field('category');
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;

    $page = 1;
    $total_pages = 1;
    $api_attributes = null;

    if ($block_leader_board->is_caching()) {
        $api_url = get_field('leader_board_api_url', 'option');
        $api_token = get_field('leader_board_api_token', 'option');
        $items = (!empty(get_field('items_per_page'))) ? get_field('items_per_page') : 10;
        $duration = (!empty(get_field('date_range'))) ? get_field('date_range') : 365;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_leader_board->get_api_attributes($items, ['category' => $category, 'duration' => $duration, 'page' => $page]);
            $response = $block_leader_board->get_resources($api_attributes, false);

            if (empty($response->message)) {
                $page = (isset($response->json['page_selected'])) ? $response->json['page_selected'] : 1;
                unset($response->json['page_selected']);
                $total_pages = (isset($response->json['total_pages'])) ? $response->json['total_pages'] : 1;
                unset($response->json['total_pages']);

                $leaders = $response->json;
            } else {
                $leaders = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }

    if (strpos($category, '-')) {
        list($category_primary, $sub_category) = explode('-', $category);
    } else {
        $sub_category = null;
        $category_primary = $category;
    }

    $menus = get_field('menu');
?>

<div class="rdg-blocks">
    <?php
        $params = ['cache_file' => null, 'api_request' => $api_attributes];
        $block_leader_board->get_log_debug($params);
    ?>
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div id="wait"></div>
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div class="table">
                <?php if (is_array($menus) && count($menus) > 0): ?>
                    <div class="table-menu">
                        <ul class="menu">
                            <?php $id = 1; ?>
                            <?php foreach($menus as $menu): ?>
                                <?php $class = ($menu['status_menu'] == 'inactive') ? $menu['status_menu'] : 'active' ?>
                                <li><a id="rdg-leader-board-link-<?php echo $id; ?>" href="#" class="<?php echo $class; ?>" data-category="<?php echo $menu['category']; ?>"><?php echo $menu['title']; ?></a></li>
                                <?php $id++; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="table-filter">
                    <div class="filter">
                        <div class="filter-option">
                            <span class="init">Categories</span>
                            <select id="rdg-leader-board-category" data-items="<?php echo $items; ?>" data-page="<?php echo $page; ?>">
                                <?php foreach ($titles_sports as $sport_key => $sport_title): ?>
                                    <?php if (is_array($sport_title)): ?>
                                        <optgroup label="<?php echo $sport_key; ?>">
                                    <?php endif; ?>

                                    <?php if (is_array($sport_title)): ?>
                                        <?php foreach ($sport_title as $key => $sub_titles ): ?>
                                            <?php $select = ''; ?>
                                            <?php if ($key == $category_primary.'-'.$sub_category): ?>
                                                <?php $select = 'selected'; ?>
                                            <?php endif; ?>
                                            
                                            <option value="<?php echo $key; ?>" <?php echo $select; ?>><?php echo $sub_titles; ?></option>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <?php $select = ''; ?>
                                        <?php if ($sport_key == $category_primary): ?>
                                            <?php $select = 'selected'; ?>
                                        <?php endif; ?>
                                        <option value="<?php echo $select; ?>" <?php echo $select; ?>><?php echo $sport_title; ?></option>
                                    <?php endif; ?>

                                    <?php if (is_array($sport_title)): ?>
                                        </optgroup>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="filter-option">
                            <span>Bet Type</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </div>
                        <div class="filter-option">
                            <span>Period</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </div>
                        <div class="filter-option">
                            <span>Date Range</span>
                            <select id="rdg-leader-board-date-range">
                                <?php foreach ($date_ranges as $range_key => $range_title): ?>
                                    <?php $select = ''; ?>
                                    <?php if ($range_key == $duration): ?>
                                        <?php $select = 'selected'; ?>
                                    <?php endif; ?>
                                    <option value="<?php echo $range_key; ?>" <?php echo $select; ?>><?php echo $range_title; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="filter-option">
                            <span>Pick Range</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="list">
                    <div class="list-items">
                        <?php if (is_array($leaders) && count($leaders) > 0): ?>
                            <?php require 'partials/api.php'; ?>
                        <?php else: ?>
                            <?php if (!empty($message)): ?>
                                <?php require 'partials/message.php'; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
