let handicappers_blocks = document.querySelectorAll(".rdg-handicappers-hub");

if (handicappers_blocks.length > 0) {
    handicappers_blocks.forEach((block) => {
        let block_id = block.querySelector(".filters").getAttribute("data-block-id");
        let dropdownSports = block.querySelectorAll(".section-dropdown a");
        let selected = block.querySelector(".dropdown-container .for-dropdown");
        let dropdownSportList = block.querySelector(".dropdown");
        let sportData = block.querySelector(".filter-sport");
        let defaultSports = block.querySelectorAll(".default-sports a");
        let packageData = block.querySelector(".filter-packages");

        dropdownSports.forEach((sportDropdown) => {
            sportDropdown.addEventListener("click", function (event) {
                event.preventDefault();

                // Cerrar dropdown al seleccionar un deporte
                dropdownSportList.checked = false;

                // Si el sportDropdown no es el activo
                if (!sportDropdown.classList.contains("active")) {
                    // Mostrar capa de carga
                    block.querySelector("#wait").style.display = "block";

                    // Setear el valor del deporte seleccionado en input para su posterior uso
                    sportData.setAttribute("data-sport-id", sportDropdown.getAttribute("data-sport-id")
                    );

                    // Tomar el nombre del deporte seleccionado y mostrarlo en el dropdown
                    let sportName = sportDropdown.innerHTML.replace(/<i[^>]*>.*?<\/i>/g, "").trim();

                    // Mostrar el deporte seleccionado en el dropdown
                    selected.innerHTML = sportName + ' <i class="uil fal fa-chevron-down"></i>';

                    // Desactivar los deportes por defecto
                    deactivateDefaultSports(defaultSports);

                    // Desactivar los deportes del dropdown
                    deactivateDropdownSports(dropdownSports);

                    dropdownSports.forEach((sportD) => {
                        // Eliminar la clase activate de los deportes del dropdown
                        sportD.classList.remove("active");

                        // Eliminar el icono de check de los deportes del dropdown
                        sportD.innerHTML = sportD.innerHTML.replace(/<i[^>]*>.*?<\/i>/g, "").trim();
                    });

                    // Agregar la clase active al deporte seleccionado
                    sportDropdown.classList.add("active");

                    // Agregar el icono de check al deporte seleccionado
                    sportDropdown.innerHTML += ' <i class="fal fa-check"></i>';

                    // Si el deporte seleccionado es el primero del dropdown, agregar la clase active al primer default sport
                    if (!sportDropdown.getAttribute("data-sport-id")) {
                        defaultSports[0].classList.add("active");
                    }

                    // Crear el llamado a la función getHandicappers con los parámetros necesarios
                    getHandicappers(block, sportDropdown, sportData, packageData);
                }
            });
        });

        defaultSports.forEach((sportDefault) => {
            sportDefault.addEventListener("click", function (event) {
                event.preventDefault();

                // Si el sportDefault no es el activo
                if (!sportDefault.classList.contains("active")) {
                    // Setear el valor del deporte seleccionado en input para su posterior uso
                    sportData.setAttribute("data-sport-id", sportDefault.getAttribute("data-sport-id"));

                    // Mostrar capa de carga
                    block.querySelector("#wait").style.display = "block";

                    // Si el default sport seleccionado no esta activo, se activa y se desactivan los demas
                    if (!sportDefault.classList.contains("active")) {
                        // Desactivar los deportes por defecto
                        deactivateDefaultSports(defaultSports);

                        // Activar el default sport seleccionado
                        sportDefault.classList.add("active");
                    }

                    let top_link = 1;
                    let top_link_selected = "";

                    // Si el default sport seleccionado es el primero, se activa solo el primer deporte del dropdown
                    if (!dropdownSports[0].classList.contains("active")) {
                        dropdownSports.forEach((sportD) => {
                            if (top_link == 1) {
                                top_link_selected = sportD.innerHTML;
                                sportD.classList.add("active");
                                sportD.innerHTML += ' <i class="fal fa-check"></i>';
                            } else {
                                sportD.classList.remove("active");
                                sportD.innerHTML = sportD.innerHTML.replace(/<i[^>]*>.*?<\/i>/g, "").trim();
                            }

                            top_link++;
                        });

                        selected.innerHTML = top_link_selected + '<i class="uil fal fa-chevron-down"></i>';
                    }

                    // Crear el llamado a la función getHandicappers con los parámetros necesarios
                    getHandicappers(block, sportDefault, sportData, packageData);
                }
            });
        });

        let packages = block.querySelectorAll(".filter-packages .package");

        packages.forEach((packageItem) => {
            packageItem.addEventListener("click", function (event) {
                event.preventDefault();

                // Si el packageItem no es el activo
                if (!packageItem.classList.contains("active")) {
                    // Mostrar capa de carga
                    block.querySelector("#wait").style.display = "block";

                    // Desactivar todos los packages
                    deactivatePackages(packages);

                    // Activar el package seleccionado
                    packageItem.classList.add("active");

                    // Setear el valor del package seleccionado en packageData para su posterior uso
                    packageData.setAttribute("data-package-id", packageItem.getAttribute("data-package-id"));

                    // Crear el llamado a la función getHandicappers con los parámetros necesarios
                    // El segundo parametro también debe ser sportData, ya que es el deporte seleccionado
                    getHandicappers(block, sportData, sportData, packageData);
                }
            });
        });
    });
}

function deactivateDefaultSports(defaultSports) {
    defaultSports.forEach((defaultSport) => {
        defaultSport.classList.remove("active");
    });
}

function deactivateDropdownSports(dropdownSports) {
    dropdownSports.forEach((dropdownSport) => {
        dropdownSport.classList.remove("active");
        dropdownSport.innerHTML = dropdownSport.innerHTML.replace(/<i[^>]*>.*?<\/i>/g, "").trim();
    });
}

function deactivatePackages(packages) {
    packages.forEach((packageItem) => {
        packageItem.classList.remove("active");
    });
}

function getHandicappers(block, sport, sportData, packageData) {
    let ajax_url = rdg_handicappers_hub_var.ajaxurl;

    let sport_id = sport.getAttribute("data-sport-id");
    let items = sportData.getAttribute("data-items");
    let duration = sportData.getAttribute("data-duration");
    let exclude = sportData.getAttribute("data-cappers-exclude");
    let packageId = packageData.getAttribute("data-package-id");

    fetch(ajax_url, {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: `action=load_handicappers_hub&exclude=${exclude}&duration=${duration}&packageId=${packageId}&items=${items}&sport=${sport_id}`,
    })
    .then((response) => response.text())
    .then((resultado) => {
        block.querySelector(".handicappers").innerHTML = resultado.trim();
        block.querySelector("#wait").style.display = "none";
    })
    .catch((err) => console.error(err));
}
