<?php 
$picks = get_field('picks');
if (is_array($picks) && !empty($picks)):
    foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="sport"><?= $pick['category']; ?></div>
            <div class="date-time"><?= $pick['time']; ?></div>
            <div class="status"><?= $pick['status']; ?></div>
        </div>
        <div class="pick-body">
        <?php if (is_array($pick['teams']) && count($pick['teams']) > 0 && count($pick['teams']) == 2): ?>
            <?php $teams = 0; ?>
            <?php foreach($pick['teams'] as $team): ?>
            <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>
                <div class="team <?php echo $class_team; ?>">
                    <div class="team-logo">
                    <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                        <img src="<?php echo $team['logo']['url']; ?>" alt="">
                    <?php endif; ?>
                    </div>
                    <div class="team-name">
                        <span><?php echo $team['name']; ?></span>
                    </div>
                </div>
                <?php if ($teams == 0): ?>
                <div class="team-vs">
                    <div class="vs-logo">
                        <span>vs</span>
                    </div>
                </div>
                <?php endif;?>
                <?php $teams++; ?>
            <?php endforeach; ?>
        <?php endif; ?>
        </div>
        <div class="pick-footer">
            <?php if (isset($pick['picks_availables']) && !empty($pick['picks_availables'])): ?>
                <a href="<?php echo esc_url($pick['picks_availables']['url']); ?>" target="<?php echo esc_attr( $pick['picks_availables']['target'] ); ?>" class="pick-btn">
                    <?php echo esc_html($pick['picks_availables']['title']); ?>
                </a>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach;
endif; ?>