<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Base
{
    public function getBlockName() {
        return $this->block_name;
    }

    public function getBlockTitle() {
        return $this->block_title;
    }

    public function getBlockInternalField() {
        if (property_exists($this, 'interval_field')) {
            return $this->interval_field;
        } else {
            return false;
        }
    }

    public function isCaching() {
        if (property_exists($this, 'is_caching')) {
            return $this->is_caching;
        } else {
            return false;
        }
    }

    public function isConfig() {
        if (property_exists($this, 'is_config')) {
            return $this->is_config;
        } else {
            return false;
        }
    }

    public function isStylesLoad() {
        if (property_exists($this, 'is_styles_load')) {
            return $this->is_styles_load;
        } else {
            return false;
        }
    }

    public function getConfig() {
        $config = [
            'page_title' => '',
            'menu_title' => '',
        ];

        if ($this->isConfig()) {
            $config['page_title'] = $this->config_page_title;
            $config['menu_title'] = $this->config_menu_title;
        }

        return $config;
    }

    public function getLogDebug($params) {
        global $rdgb;
        $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

        if ($rdgb->helpers->rdgDebugRequest($params['api_request'])) {
            echo sprintf('<!--Request: %s-->', $params['api_request']['request']);
        }

        $cache = $rdgb->cache->getCacheBlock($params['cache_name']);
        if ($cache) {
            try {
                $cache_decode = json_decode($cache, true);
                $response = isset($cache_decode['api_response']) ? $cache_decode['api_response'] : null;
                echo '<!-- Cache File: '.$params['cache_name'].' ';
                print_r($response);
                echo '-->';
            } catch (\Exception $exception) {
                //
            }
        }
    }

    public function isPreSaved() {
        if (property_exists($this, 'is_pre_saved')) {
            return $this->is_pre_saved;
        } else {
            return false;
        }
    }
}
