<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_HANDICAPPERS_HUB;
    $block_classes = [$block_name];
    $block_handicappers_hub = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $items = (!empty(get_field('number_of_items'))) ? get_field('number_of_items') : 8;
    $sport = (!empty(get_field('handicapppers_hub_sport'))) ? get_field('handicapppers_hub_sport') : null;
    $capper_exclude = (!empty(get_field('handicapppers_hub_handicappers'))) ? get_field('handicapppers_hub_handicappers') : [];
    $duration = (!empty(get_field('handicapppers_hub_date_range'))) ? get_field('handicapppers_hub_date_range') : 365;
    $package = (!empty(get_field('handicapppers_hub_package'))) ? get_field('handicapppers_hub_package') : 0;

    $handicappers_string = '';
    if (is_array($capper_exclude) && count($capper_exclude) > 0) {
        $handicappers_string = $block_handicappers_hub->gerHandicappersExclude($capper_exclude, false);
    }
    
    $items = null;
    $cache_name = null;
    $handicappers = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($block_handicappers_hub->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $rdgb->cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $handicappers = isset($cache_block_array['api_response']['handicappers']) ? $cache_block_array['api_response']['handicappers'] : [];
            $items = $cache_block_array['items'];
        }
    }

    $fields = $block_handicappers_hub->getFieldsValidate();

    # Default sports and other sports are defined for the filter
    $default_sports = ['basketball','hockey','football','soccer'];
    $sports = $block_handicappers_hub->getSports($default_sports);
    $packages = $block_handicappers_hub->getHandicappersHubPackages();
?>

<?php if (is_array($handicappers) && count($handicappers) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_handicappers_hub->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
                
                <div class="handicappers-body">
                    <div id="wait"></div>
                    <div class="filters" data-block-id="<?php echo $block['id']; ?>">
                        <div class="filter-sport" data-sport-id="<?php echo $sport; ?>" data-items="<?php echo $items; ?>" data-duration="<?php echo $duration; ?>" data-cappers-exclude='<?php echo json_encode($capper_exclude); ?>'>
                            <div class="default-sports">
                                <?php
                                    if (isset($sports['default_sports'][$sport]) || isset($sports['all_sports'][$sport])) {
                                        $all_sport_activate = '';
                                    } else {
                                        $all_sport_activate = ' active';
                                    }
                                ?>
                                <a href="#" class="sport<?php echo $all_sport_activate; ?>" data-sport-id="">All Sports</a>
                                <?php if (isset($sports['default_sports']) && is_array($sports['default_sports']) && count($sports['default_sports']) > 0): ?>
                                    <?php foreach ($sports['default_sports'] as $key => $sport_name): ?>
                                        <?php $active_class = ($key == $sport) ? ' active' : ''; ?>
                                        <a href="#" class="sport<?php echo $active_class; ?>" data-sport-id="<?php echo $key; ?>"><?php echo $sport_name; ?></a>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <div class="sports-list">
                                <div class="dropdown-container"> 	
                                    <input class="dropdown" type="checkbox" id="dropdown-<?php echo $block['id']; ?>" name="dropdown-<?php echo $block['id']; ?>"/>
                                    <?php
                                        if(isset($sports['all_sports'][$sport]) && !empty($sports['all_sports'][$sport])) {
                                            $dropdown_sport_ico = '';
                                            $dropdown_sport_activate = '';
                                            $dropdown_sport_name = $sports['all_sports'][$sport];
                                        } else  {
                                            $dropdown_sport_name = 'other sports';
                                            $dropdown_sport_activate = ' active';
                                            $dropdown_sport_ico = ' <i class="fal fa-check"></i>';
                                        }
                                    ?>
                                    <label class="for-dropdown" for="dropdown-<?php echo $block['id']; ?>"><?php echo $dropdown_sport_name; ?> <i class="uil fal fa-chevron-down"></i></label>
                                    <div class="section-dropdown">
                                        <a href="#" data-sport-id="" class="sport<?php echo $dropdown_sport_activate; ?>">Other Sports<?php echo $dropdown_sport_ico; ?></a>
                                        <?php if (isset($sports['all_sports']) && is_array($sports['all_sports']) && count($sports['all_sports']) > 0): ?>
                                            <?php foreach ($sports['all_sports'] as $key => $sport_name): ?>
                                                <?php
                                                    if ($key == $sport) {
                                                        $active_class = ' active';
                                                        $active_ico = ' <i class="fal fa-check"></i>';
                                                    } else {
                                                        $active_class = '';
                                                        $active_ico = '';
                                                    }
                                                ?>
                                                <a href="#" class="sport<?php echo $active_class; ?>" data-sport-id="<?php echo $key; ?>"><?php echo $sport_name.$active_ico; ?></a>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="filter-packages" data-package-id="<?php echo $package; ?>">
                            <?php if (is_array($packages) && count($packages) > 0): ?>
                                <?php foreach ($packages as $keyPack => $pack): ?>
                                    <?php $package_class = ($keyPack == $package) ? ' active' : ''; ?>
                                    <a href="#" class="package<?php echo $package_class; ?>" data-package-id="<?php echo $keyPack; ?>"><?php echo $pack; ?></a>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="handicappers">
                        <?php require 'partials/api.php'; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
