<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SPORTS_PICKS_VS;
    $block_classes = [$block_name];
    $block_sports_picks_vs = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];
 
    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $source = get_field('source');
    $titles = get_field('titles');
    $picks = get_field('picks');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : 'now';
    $date = (!empty(get_field('date'))) ? get_field('date') : null;
    $link_options = (!empty(get_field('link_options'))) ? get_field('link_options') : 'none';
    $all_link = (!empty(get_field('all_link'))) ? get_field('all_link') : null;
    $custom_link = (!empty(get_field('custom_link'))) ? get_field('custom_link') : null;
    $sports_parts = (!empty(get_field('sports_parts'))) ? get_field('sports_parts') : null;
    $date_request = $block_sports_picks_vs->get_date_filter($date_type, $date);

    $cache_name = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($source == 'api' && $block_sports_picks_vs->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $rdgb->cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $picks = $cache_block_array['api_response'];
            $items = $cache_block_array['items'];
        }
    }
?>
<?php if (is_array($picks) && count($picks) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_sports_picks_vs->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

                <div class="picks">
                    <?php if (!empty($picks)): ?>
                        <?php
                            if ($source == 'api') {
                                require 'partials/api.php';
                            } else {
                                require 'partials/manual.php';
                            }
                        ?>
                    <?php else: ?>
                        <?php if (!empty($message)): ?>
                            <span class="message"><?php echo $message; ?></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
