<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_TOP_CAPPERS;
    $block_classes = [$block_name];
    $block_top_cappers = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $primary_capper = 0;
    $titles = get_field('titles');
    $title = (!empty(get_field('title'))) ? get_field('title') : '';
    $cappers = (!empty(get_field('cappers'))) ? get_field('cappers') : [];
    $source = get_field('source');
    $display_block = (!empty(get_field('display_block'))) ? get_field('display_block') : 'full-width';
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    $period = (!empty(get_field('period'))) ? get_field('period') : '';

    $cache_name = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($source == 'api' && $block_top_cappers->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $rdgb->cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $cappers = $cache_block_array['api_response'];
            $items = $cache_block_array['items'];
        }
    }
?>

<?php if (is_array($cappers) && count($cappers) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_top_cappers->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $display_block; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
                <?php
                    if ($source == 'api') {
                        require 'partials/api.php';
                    } else {
                        require 'partials/manual.php';
                    }
                ?>
            </div>
        </div>
    </div>
<?php endif; ?>