document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll("[name='redis-cache-delete']").forEach(button => {
        button.addEventListener("click", function (event) {
            event.preventDefault();

            let button = this;
            let cache = this.getAttribute("data-cache");

            if (button.disabled === true) {
                return;
            }

            console.log("Deleting...");

            button.disabled = true;
            button.textContent = "Deleting...";

            fetch(ajaxurl, {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `action=rdg_blocks_delete_cache&cache=${cache}`,
            })
            .then((response) => response.text())
            .then((resultado) => {
                let item = this.parentElement.parentElement;

                button.disabled = false;
                button.textContent = "Delete";

                item.remove();
            })
            .catch((err) => console.error(err));
        });
    });

    document.querySelectorAll("[name='redis-cache-update']").forEach(button => {
        button.addEventListener("click", function (event) {
            event.preventDefault();
            let button = this;
            let cache = this.getAttribute("data-cache");

            if (button.disabled === true) {
                return;
            }

            button.disabled = true;
            button.textContent = "Updating...";

            fetch(ajaxurl, {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `action=rdg_blocks_update_cache&cache=${cache}`,
            })
            .then((response) => response.text())
            .then((resultado) => {
                let idSelector = `api_response_item_${cache}`.replace(/:/g, "\\:");
                document.querySelector('.' + idSelector + ' pre').innerHTML = resultado;

                button.disabled = false;
                button.textContent = "Update";
            })
            .catch((err) => console.error(err));
        });
    });

    document.querySelectorAll("select.filter_cache").forEach(select => {
        select.addEventListener("change", function () {
            let url = new URL(window.location.href);

            document.querySelectorAll("select.filter_cache").forEach(sel => {
                let paramName = sel.id;
                let paramValue = sel.value;

                if (paramValue && paramValue !== "") {
                    url.searchParams.set(paramName, paramValue);
                } else {
                    url.searchParams.delete(paramName);
                }
            });

            window.location.href = url.toString();
        });
    });

    document.querySelector("[name='redis-cache-delete-all']").addEventListener("click", function (event) {
        event.preventDefault();

        let button = this;

        if (button.disabled === true) {
            return;
        }

        // Desactivar el botón
        button.disabled = true;
        button.textContent = "Eliminando caché...";
        console.log("Eliminando todo el caché...");

        setTimeout(() => {
            button.disabled = false;
            button.textContent = "Eliminar todo el caché";
        }, 5000);

        // button.disabled = false;
        // button.textContent = "Eliminar todo el caché";




        // fetch(ajaxurl, {
        //     method: "POST",
        //     headers: { "Content-Type": "application/x-www-form-urlencoded" },
        //     body: "action=rdg_blocks_delete_cache_all",
        // })
        // .then(response => response.text())
        // .then(resultado => {
        //     console.log("Caché eliminado:", resultado);
        //     alert("Todo el caché ha sido eliminado correctamente.");
        // })
        // .catch(err => console.error("Error al eliminar todo el caché:", err));
    });

    function populateSelect(selectId, data, selectedValue) {
        let select = document.getElementById(selectId);
        if (!select) return;

        select.innerHTML = "";

        let defaultOption = document.createElement("option");
        defaultOption.value = "";
        defaultOption.textContent = "Select an option";
        select.appendChild(defaultOption);

        data.forEach(item => {
            let option = document.createElement("option");
            option.value = item;
            option.textContent = item;
            select.appendChild(option);

            if (selectedValue && selectedValue === item) {
                option.selected = true;
            }

            select.appendChild(option);
        });
    }

    populateSelect("filter_type", jsonData.data_filter_type, jsonData.selected.filter_type);
    populateSelect("filter_type_id", jsonData.data_filter_type_ids, jsonData.selected.filter_type_id);
    populateSelect("filter_block_type", jsonData.data_filter_block_types, jsonData.selected.filter_block_type);
});

