<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Parlay_Calculator extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PARLAY_CALCULATOR;
    private $block_folder_name = 'rdg-parlay-calculator';
    protected $block_title = 'RDG Parlay Calculator';
    private $block_description = 'This block is a calculator for parlay bets.';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'parlay', 'calculator'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_parlay_calculator.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-parlay-results-template-preview.png",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            [
                'name' => 'color-rdg-parlay-calculator-primary',
                'slug' => 'color-rdg-parlay-calculator-primary',
                'color' => '#1c4579'
            ],
            [
                'name' => 'color-rdg-parlay-calculator-border-container',
                'slug' => 'color-rdg-parlay-calculator-border-container',
                'color' => '#e4e4e4'
            ],
            [
                'name' => 'color-rdg-parlay-calculator-border-input',
                'slug' => 'color-rdg-parlay-calculator-border-input',
                'color' => '#c9c9c9'
            ],
            [
                'name' => 'color-rdg-parlay-calculator-border-invalid',
                'slug' => 'color-rdg-parlay-calculator-border-invalid',
                'color' => '#ff0010'
            ],
            [
                'name' => 'color-rdg-parlay-calculator-border-eg',
                'slug' => 'color-rdg-parlay-calculator-border-eg',
                'color' => '#525252'
            ],
            [
                'name' => 'color-rdg-parlay-calculator-btn-hover',
                'slug' => 'color-rdg-parlay-calculator-btn-hover',
                'color' => '#0160ac'
            ],
        ];
    }

    // public function getStylesToloadGeneratePress() {
    //     return [];
    // }
}

$rdg_parlay_calculator_class = new Rdg_Blocks_Parlay_Calculator();
$rdg_parlay_calculator_class->init();

return $rdg_parlay_calculator_class;
