<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $name_block = BLOCK_RDG_PRODUCT_REPORT;
    $block_classes = [$name_block];
    $block_product_report = $rdgb->settings->getBlock($name_block);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $header_title = (!empty(get_field('header_title'))) ? get_field('header_title') : null;
    $content = (!empty(get_field('content'))) ? get_field('content') : null;
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div class="header">
                <div class="header-title">
                    <span>
                        <?php echo $header_title; ?>
                    </span>
                </div>
                <div class="header-icon">
                    <svg width="28px" height="28px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" class="bi bi-arrow-down-circle-fill">
                        <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM8.5 4.5a.5.5 0 0 0-1 0v5.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V4.5z"/>
                    </svg>
                </div>
            </div>
            <?php if (!empty($content)): ?>
                <div class="body">
                    <?php echo $content; ?>
                </div>
            <?php else: ?>
                <div class="message danger">
                    <span><?php echo __('You must add a paragraph.'); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
