<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Admin_Cappers_Simple extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_ADMIN_CAPPERS_SIMPLE;
    private $block_folder_name = 'rdg-admin-cappers-simple';
    protected $block_title = 'RDG Admin Cappers Simple';
    private $block_description = 'A card style block with short info about games and release dates';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'admin', 'capper', 'simple', 'api'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $is_styles_load = true;
    protected $config_page_title = 'RDG Admin Capper Simple';
    protected $config_menu_title = 'Admin Capper Simple';
    protected $interval_field = 'admin_cappers_simple_interval';

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_admin_cappers_simple.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-admin-cappers-simple-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'render_callback' => function($block) use ($rdg_helpers) {
                    global $wp_query;
                    $loop = $wp_query->in_the_loop;
                    $template_path = RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php";

                    if ($loop) {
                        include $template_path;
                        return;
                    }

                    $trace_config = $rdg_helpers->getBacktraceConfig();
                    $traces = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, $trace_config['max_trace']);
                    $trace_valid_admin = $rdg_helpers->checkExistsTraceFunction($traces, $trace_config['max_trace'], $trace_config['functions']);

                    if (is_admin() && !$trace_valid_admin) {
                        include $template_path;
                        return;
                    }
                },
            ]);
        }
    }

    public function register_fields() {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $sports = (function_exists('getSporstHierarchyOptions')) ? getSporstHierarchyOptions() : [];

        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group( array(
                'key' => 'group_63d3d627ab167',
                'title' => 'Block RDG Admin Cappers Simple',
                'fields' => array(
                    array(
                        'key' => 'field_648ca83bf1bf8',
                        'label' => 'Show In',
                        'name' => 'show_in',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'full' => 'Full width',
                            'content' => 'Content width',
                        ),
                        'default_value' => 'full',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_648ca900f0fa4',
                        'label' => 'Source',
                        'name' => 'source',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'manual' => 'Manual',
                            'api' => 'API',
                        ),
                        'default_value' => 'manual',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_648ca87d66a8c',
                        'label' => 'Link Options',
                        'name' => 'link_options',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648ca900f0fa4',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'none' => 'None',
                            'default' => 'API',
                            'custom' => 'Custom',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_648ca8ab66a8d',
                        'label' => 'Link',
                        'name' => 'custom_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648ca87d66a8c',
                                    'operator' => '==',
                                    'value' => 'custom',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'field_648cab35badbd',
                        'label' => 'Filter Date',
                        'name' => 'filter_date',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648ca900f0fa4',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hide' => 'Hide',
                            'show' => 'Show',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_648cab82badbe',
                        'label' => 'Date Type',
                        'name' => 'date_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648cab35badbd',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'yesterday' => 'Yesterday',
                            'now' => 'Now',
                            'tomorrow' => 'Tomorrow',
                            'range' => 'Range',
                        ),
                        'default_value' => 'now',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_648cabbdbadbf',
                        'label' => 'Since Date',
                        'name' => 'since_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648cab82badbe',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_648cabe3badc0',
                        'label' => 'To Date',
                        'name' => 'to_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648cab82badbe',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_648ca9e98b1fd',
                        'label' => 'Category',
                        'name' => 'category',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648ca900f0fa4',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => [0 => 'Choose an option'] + $sports,
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_648caaa2badbc',
                        'label' => 'Number of Items',
                        'name' => 'number_of_items',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648ca900f0fa4',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 3,
                        'min' => 1,
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63d3d627b5475',
                        'label' => 'Cappers',
                        'name' => 'cappers',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_648ca900f0fa4',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d3d627d2fad',
                                'label' => 'Category',
                                'name' => 'category',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3d627d6c93',
                                'label' => 'Date',
                                'name' => 'date',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3d9ec496be',
                                'label' => 'Handicap',
                                'name' => 'handicap',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3de56bdeb4',
                                'label' => 'Show Logo?',
                                'name' => 'show_logo',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'show' => 'Show',
                                    'hide' => 'Hide',
                                ),
                                'default_value' => '',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3ddeba936d',
                                'label' => 'Home Team Logo',
                                'name' => 'home_team_logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3d627de17e',
                                'label' => 'Home Team Name',
                                'name' => 'home_team',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3de0ca936e',
                                'label' => 'Visitor Team Logo',
                                'name' => 'visitor_team_logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3d627e1d96',
                                'label' => 'Visitor Team Name',
                                'name' => 'visitor_team',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3d627e5842',
                                'label' => 'Release Date',
                                'name' => 'release_date',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3d627da7e3',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                            array(
                                'key' => 'field_63d3d627e92e0',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63d3d627b5475',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-admin-cappers-simple',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_admin_cappers_simple_block_asdasdsadsaad',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'field_648c9f3b010a6',
                        'label' => 'URL',
                        'name' => 'admin_cappers_simple_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '70',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_648c9f3b04a6c',
                        'label' => 'Cache Refresh Frequency (Hours)',
                        'name' => 'admin_cappers_simple_interval',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_648c9f3b08410',
                        'label' => 'Token',
                        'name' => 'admin_cappers_simple_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-admin-capper-simple',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getApiAttributes($items = null, $attributes = []) {
        $api_url = get_field('admin_cappers_simple_api_url', 'option');
        $api_token = get_field('admin_cappers_simple_api_token', 'option');
        $cache_refresh = get_field('admin_cappers_simple_interval', 'option');
        $items = (!empty($items)) ? intval($items) : 10;

        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;
        $api_url .= '?gamesToShow='.$items;

        if (isset($attributes['category']) && strpos($attributes['category'], '-')) {
            list($hierarchy_id, $sub_category) = explode('-', $attributes['category']);
        } else {
            $sub_category = null;

            if (isset($attributes['category']) && !empty($attributes['category'])) {
                $hierarchy_id = $attributes['category'];
            } else {
                $hierarchy_id = 130; // Default to BASEBALL (first group from API)
            }
        }

        $api_url .= '&hierarchy='.$hierarchy_id;
        
        // Note: New API structure may not need sub_category parameter
        // Keeping for backward compatibility, but can be removed if not used
        if (!empty($sub_category)) {
            $api_url .= '&category='.$sub_category;
        }

        if (isset($attributes['date']) && is_array($attributes['date']) && count($attributes['date']) == 2) {
            if (!empty($attributes['date']['start'])) {
                $api_url .= '&principalDate='.$attributes['date']['start'];
            }
            
            if (!empty($attributes['date']['end'])) {
                $api_url .= '&secondaryDate='.$attributes['date']['end'];
            }
        }

        $api_request = $api_url.'&api_token='.$api_token;

        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
            'hierarchy' => $hierarchy_id,
            'category_primary' => $hierarchy_id, // Backward compatibility
            'sub_category' => $sub_category,
        ];
    }

    public function getApiParams() {
        return [
            'category' => 'category',
            '_to_transform_' => [
                [
                    'key' => 'date',
                    'function' => 'get_date_filter',
                    'params' => ['date_type', 'since_date', 'to_date'],
                    'fields_date' => ['since_date', 'to_date'],
                ]
            ],
        ];
    }

    public function get_date_filter($date_type, $since_date, $to_date) {
        $date = [
            'start' => null,
            'end' => null
        ];

        if ($date_type == API_DATE_TYPE_YESTERDAY) {
            $date['start'] = date('Y-m-d', strtotime("-1 days"));

            return $date;
        }

        if ($date_type == API_DATE_TYPE_NOW) {

            return $date;
        }
        
        if ($date_type == API_DATE_TYPE_TOMORROW) {
            $date['start'] = date('Y-m-d',strtotime("+1 days"));
            
            return $date;
        }

        if ($date_type == API_DATE_TYPE_RANGE) {
            if (!empty($since_date) && !empty($to_date)) {
                $date['start'] = $since_date;
                $date['end'] = $to_date;
            
                return $date;
            }

            if (empty($since_date) && empty($to_date)) {
                return $date;
            }

            if (!empty($since_date) && empty($to_date)) {
                $date['start'] = $since_date;
            
                return $date;
            }

            if (empty($since_date) && !empty($to_date)) {
                $date['start'] = $to_date;
            
                return $date;
            }
        }

        return $date;
    }

    public function get_image($url_image, $attributes = []) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $url_image = $rdgb_helpers->getImageSource($url_image, $attributes);

        return $url_image;
    }

    public function getFieldsValidate() {
        return [
            'game_date' => ['required', 'notnull'],
            'visitor_name' => ['required', 'notnull'],
            'home_name' => ['required', 'notnull'],
            'game_stat' => ['required', 'notnull'],
            'num_picks' => ['required', 'notnull'],
            'game_url' => ['required', 'notnull'],
            'visitor_image' => ['required', 'notnull'],
            'home_image' => ['required', 'notnull'],
        ];
    }

    public function getPreSavedData($data, $attributes = []) {
        return $data;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-admin-cappers-capper-title','slug' => 'color-admin-cappers-capper-title','color' => '#111111'],
            ['name' => 'color-admin-cappers-capper-sub-title','slug' => 'color-admin-cappers-capper-sub-title','color' => '#3a96e0'],
            ['name' => 'color-admin-cappers-capper-total','slug' => 'color-admin-cappers-capper-total','color' => '#111111'],
            ['name' => 'color-admin-cappers-capper-picks','slug' => 'color-admin-cappers-capper-picks','color' => '#00bc00'],
            ['name' => 'color-admin-cappers-capper-teams','slug' => 'color-admin-cappers-capper-teams','color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-admin-cappers-simple .cappers .capper .content .capper-content .content-teams-logo',
                'fontWeight' => '700',
                'textTransform' => 'uppercase',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-admin-cappers-simple .cappers .capper .content .capper-content .content-teams',
                'fontWeight' => '700',
                'textTransform' => 'uppercase',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-admin-cappers-simple .cappers .capper .content .capper-content .content-teams-logo .teams .team-vs .vs-logo span',
                'fontWeight' => '500',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-admin-cappers-simple .cappers .capper .content .capper-content .content-teams-logo .teams .team-vs .vs-name span',
                'fontWeight' => '600',
                'fontSize' => '0.9rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-admin-cappers-simple .cappers .capper .content .capper-content .content-release',
                'fontWeight' => '600',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-admin-cappers-simple .cappers .capper .content .capper-content .content-category .category, .rdg-admin-cappers-simple .cappers .capper .content .capper-content .content-category .handicap, .rdg-admin-cappers-simple .cappers .capper .capper-footer .footer-status',
                'fontWeight' => '600',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-admin-cappers-simple .cappers .capper .capper-footer .footer-link',
                'fontWeight' => '600',
                'textDecoration' => 'none',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-admin-cappers-simple a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_admin_cappers_simple_class = new Rdg_Blocks_Admin_Cappers_Simple();
$rdg_admin_cappers_simple_class->init();

return $rdg_admin_cappers_simple_class;
