<?php  
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_MEMBERSHIP_INFO;
    $block_membership_info = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : $block['id'];

    $cache = new Rdg_Blocks_Cache();
    $connect = $cache->getRedisConnect();
    if (!$connect) {
        error_log(sprintf('%s / %s: Redis connection failed.', RDGBLOCKS_NAME, $block_name));
        return;
    }

    $blockTitle = get_field('title');
    $source = get_field('source');

    // Manual
    $premiumPackage = get_field('premium_package');
    $classicPackage = get_field('classic_package');
    $starterPlusPackage = get_field('starter_plus_package');
    $starterPackage = get_field('starter_package');

    // API
    $premiumPackageAPI = get_field('premium_package_api');
    $classicPackageAPI = get_field('classic_package_api');
    $starterPlusPackageAPI = get_field('starter_plus_package_api');
    $starterPackageAPI = get_field('starter_package_api');
    
    $items = null;
    $cache_name = null;
    $memberships = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($block_membership_info->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $memberships = $cache_block_array['api_response'];
            $items = $cache_block_array['items'];
        }
    }
?>

<?php if (!empty($memberships)): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_membership_info->getLogDebug($params);
        ?>
        <div class="rdg-membership-info">
            <div class="mi_section">
                <div class="mi_wrapper">
                    <?php
                        if ($source == 'api') {
                            require 'partials/api.php';
                        } else {
                            require 'partials/manual.php';
                        }
                    ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
