<div class="table-wrapper">
    <table class="sortable">
        <thead>
            <tr>
                <th class="w-1 static-column">#</th>
                <th class="name w-2">NAME</th>
                <th class="w-3">TOTAL BETS</th>
                <th class="w-4">WIN</th>
                <th class="w-5">LOSS</th>
                <th class="w-6">PUSH</th>
                <th class="w-7">WIN%</th>
                <th class="w-8">NET</th>
                <th class="w-9">GROUPS</th>
                <th class="w-10">LAST PICK DATE</th>
            </tr>
        </thead>
        <tbody>
            <?php $fields = $block_leader_board->getFieldsValidate(); ?>
            <?php foreach ($leaders as $key => $leader): ?>
                <?php
                    $package_url = null;
                    $package_name = $members_default;
                    
                    if (isset($members[$leader['id_group']]) && !empty($members[$leader['id_group']])) {
                        $package_url = (isset($members[$leader['id_group']]['url']) && !empty($members[$leader['id_group']]['url'])) ? $members[$leader['id_group']]['url'] : '#';
                        $package_name = (isset($members[$leader['id_group']]['name']) && !empty($members[$leader['id_group']]['name'])) ? $members[$leader['id_group']]['name'] : '';
                    }
                ?>
                <?php if (!$rdgb->helpers->validateFields($fields, $leader)) continue; ?>
                <?php if (!empty($leader['rank']) && !empty($leader['name'])): ?>
                    <tr>
                        <?php $url = (isset($leader['handicapper_detail_url']) && !empty($leader['handicapper_detail_url'])) ? $leader['handicapper_detail_url'] : '#'; ?>
                        <td class="top w-1 static-column"><?php echo $leader['rank']; ?></td>
                        <td class="name w-2"><a href="<?php echo $url; ?>" target="_blank"><?php echo $leader['name']; ?></a></td>
                        <td class="w-3"><?php echo (!empty($leader['total_bets'])) ? $leader['total_bets'] : 0; ?></td>
                        <td class="w-4"><?php echo (!empty($leader['win'])) ? $leader['win'] : 0; ?></td>
                        <td class="w-5"><?php echo (!empty($leader['loss'])) ? $leader['loss'] : 0; ?></td>
                        <td class="w-6"><?php echo (!empty($leader['push'])) ? $leader['push'] : 0; ?></td>
                        <td class="w-7"><?php echo number_format($leader['win_percentaje'], 2, '.', ','); ?>%</td>
                        <td class="w-8">$<?php echo number_format($leader['net'], 0, '.', ','); ?></td>
                        <td class="group w-9">
                            <?php
                                if (!empty($package_name) && !empty($package_url)) {
                                    echo '<a href="' . esc_url($package_url) . '" target="_blank">' . esc_html($package_name) . '</a>';
                                } else {
                                    echo esc_html($package_name);
                                }
                            ?>
                        </td>
                        <td class="w-10">
                            <?php
                                if (isset($leader['last_pick_date']) && !empty($leader['last_pick_date'])):
                                    $date = new DateTime($leader['last_pick_date']);
                                    echo $date->format('h:i A - Y/m/d');
                                else:
                                    echo '-';
                                endif;
                            ?>
                        </td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
