<?php
$logo_label = false;
$fields = $block_picks_vs_multi->getFieldsValidate();

if (isset($picks) && is_array($picks) && !empty($picks)):
    foreach ($picks as $pick_group):
        if (!is_array($pick_group)) continue;
        foreach ($pick_group as $pick): 
            if (!$rdgb->helpers->validateFields($fields, $pick)) continue; ?>
            
            <div class="pick">
                <div class="pick-header">
                    <div class="sport"><?php echo $pick['sport_name']; ?></div>
                    <div class="date-time">
                        <?php
                            try {
                                $d = DateTime::createFromFormat('Y-m-d H:i:s', $pick['game_date']);
                                $date_status = $d && $d->format('Y-m-d H:i:s') == $pick['game_date'];

                                if ($date_status) {
                                    echo $d->format('Y-m-d H:i');
                                }
                            } catch (\Exception $exception) {
                                //
                            }
                        ?>
                    </div>
                    <div class="status"><?= $pick['game_stat']; ?></div>
                </div>
                <div class="pick-body">
                    <div class="team team-b">
                        <div class="team-logo">
                            <?php
                                $visitor_image = $block_picks_vs_multi->get_image($pick['visitor_image'], [
                                    'image_type' => 'team_image',
                                    'image_alt' => $pick['visitor_name'],
                                    'logo_label' => $logo_label
                                ]);
                            ?>
                            <img width="90" height="90" src="<?php echo $visitor_image['url']; ?>" alt="<?php echo $visitor_image['alt']; ?>">
                        </div>
                        <div class="team-name"><span><?php echo $pick['visitor_name']; ?></span></div>
                    </div>
                    <div class="team-vs">
                        <div class="vs-logo">
                            <span>vs</span>
                        </div>
                    </div>
                    <div class="team team-a">
                        <div class="team-logo">
                            <?php
                                $home_image = $block_picks_vs_multi->get_image($pick['home_image'], [
                                    'image_type' => 'team_image',
                                    'image_alt' => $pick['home_name'],
                                    'logo_label' => $logo_label
                                ]);
                            ?>
                            <img width="90" heigt="90" src="<?php echo $home_image['url']; ?>" alt="<?php echo $home_image['alt']; ?>">
                        </div>
                        <div class="team-name"><span><?php echo $pick['home_name']; ?></span></div>
                    </div>
                </div>
                <div class="pick-footer">
                    <a href="<?= $pick['game_url']; ?>" target="_blank" class="pick-btn"><?php echo $pick['num_picks']; ?> PICKS</a>
                </div>
            </div>
            
        <?php endforeach;
    endforeach;
endif;
?>
