<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Heading extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_HEADING;
    private $block_folder_name = 'rdg-heading';
    protected $block_title = 'RDG Heading';
    private $block_description = 'The block offer the possibility to edit and use a title style with a line decoration and edit the color for this';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'heading'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_heading.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-heading-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [];
    }

    public function getStylesToloadGeneratePress() {
        return [];
    }
}

$rdg_heading_class = new Rdg_Blocks_Heading();
$rdg_heading_class->init();

return $rdg_heading_class;
