<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_LEADER_BOARD;
    $block_classes = [$block_name];
    $block_leader_board = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : $block['id'];

    $cache = new Rdg_Blocks_Cache();
    $connect = $cache->getRedisConnect();
    if (!$connect) {
        error_log(sprintf('%s / %s: Redis connection failed.', RDGBLOCKS_NAME, $block_name));
        return;
    }

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    $date_ranges = $block_leader_board->get_leader_board_date_range();
    $bet_types = $block_leader_board->getLeaderBoardBetType();
    $picks_range = $block_leader_board->getLeaderBoardPicksRange();

    $sport = (get_field('rdg_leader_board_sport') !== null) ? get_field('rdg_leader_board_sport') : null;
    $league = (get_field('rdg_leader_board_league') !== null) ? get_field('rdg_leader_board_league') : null;
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;
    $bet_type = (get_field('rdg_leader_board_bet_type') !== null) ? get_field('rdg_leader_board_bet_type') : null;
    $duration = (get_field('rdg_leader_board_date_range') !== null) ? get_field('rdg_leader_board_date_range') : null;
    $pick_range = (get_field('rdg_leader_board_picks_range') !== null) ? get_field('rdg_leader_board_picks_range') : null;

    $page = 1;
    $total_pages = 1;
    $items = null;
    $cache_name = null;
    $leaders = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($block_leader_board->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $leaders = isset($cache_block_array['api_response']) ? $cache_block_array['api_response'] : [];
            $items = $cache_block_array['items'];

            $page = (isset($leaders['page_selected'])) ? $leaders['page_selected'] : 1;
            unset($leaders['page_selected']);
            $total_pages = (isset($leaders['total_pages'])) ? $leaders['total_pages'] : 1;
            unset($leaders['total_pages']);
        }
    }

    $sports = (function_exists('shMappingHierarchySports')) ? shMappingHierarchySports() : [];

    if (is_array($sports) && count($sports) > 0) {
        $leagues = (function_exists('shMappingHierarchyFamily')) ? shMappingHierarchyFamily($sport) : [];
        $leagues = ['' => 'Choose an option'] + $leagues;
    }

    $members_default = '';
    $members = (function_exists('shMappingMembershipsData')) ? shMappingMembershipsData() : [];
    $members_logic = (function_exists('shMappingGetMembershipsLogic')) ? shMappingGetMembershipsLogic() : [];

    if (isset($members_logic[0][0]['name']) && !empty($members_logic[0][0]['name'])) {
        $members_default = $members_logic[0][0]['name'];
    }

    $disabled = '';
    if ($page >= $total_pages) {
        $disabled = 'disabled';
    }
?>

<?php if (is_array($leaders) && count($leaders) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_leader_board->getLogDebug($params);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
                
                <div id="wait"></div>
                <div class="table">
                    <div class="shadow">
                        <div class="table-filter">
                            <div class="filter">
                                <div class="filter-option">
                                    <select class="rdg-leader-board-filter" name="rdg-leader-board-sport" id="rdg-leader-board-sport" data-items="<?php echo $items; ?>" data-page="<?php echo $page; ?>" data-total-pages="<?php echo $total_pages; ?>">
                                        <?php foreach ($sports as $sport_key => $sport_title): ?>
                                            <?php $select = ''; ?>
                                            <?php if ($sport_key == $sport): ?>
                                                <?php $select = 'selected'; ?>
                                            <?php endif; ?>
                                            <option value="<?php echo $sport_key; ?>" <?php echo $select; ?>><?php echo $sport_title; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="filter-option">
                                    <select class="rdg-leader-board-filter" name="rdg-leader-board-league" id="rdg-leader-board-league">
                                        <?php foreach ($leagues as $league_key => $league_title): ?>
                                            <?php $select = ''; ?>
                                            <?php if ($league_key == $league): ?>
                                                <?php $select = 'selected'; ?>
                                            <?php endif; ?>
                                            <option value="<?php echo $league_key; ?>" <?php echo $select; ?>><?php echo $league_title; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="filter-option">
                                    <select class="rdg-leader-board-filter" name="rdg-leader-board-bet-type" id="rdg-leader-board-bet-type">
                                        <?php foreach ($bet_types as $type_key => $type_title): ?>
                                            <?php $select = ''; ?>
                                            <?php if ($type_key == $bet_type): ?>
                                                <?php $select = 'selected'; ?>
                                            <?php endif; ?>
                                            <option value="<?php echo esc_attr($type_key); ?>" <?php echo $select; ?>><?php echo $type_title; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="filter-option">
                                    <select class="rdg-leader-board-filter" name="rdg-leader-board-date-range" id="rdg-leader-board-date-range">
                                        <?php foreach ($date_ranges as $range_key => $range_title): ?>
                                            <?php $select = ''; ?>
                                            <?php if ($range_key == $duration): ?>
                                                <?php $select = 'selected'; ?>
                                            <?php endif; ?>
                                            <option value="<?php echo $range_key; ?>" <?php echo $select; ?>><?php echo $range_title; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="filter-option">
                                    <select class="rdg-leader-board-filter" name="rdg-leader-board-picks-range" id="rdg-leader-board-picks-range">
                                        <?php foreach ($picks_range as $pick_key => $pick_title): ?>
                                            <?php $select = ''; ?>
                                            <?php if ($pick_key == $pick_range): ?>
                                                <?php $select = 'selected'; ?>
                                            <?php endif; ?>
                                            <option value="<?php echo $pick_key; ?>" <?php echo $select; ?>><?php echo $pick_title; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="list">
                            <div class="list-items">
                                <?php require 'partials/api.php'; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="list-pagination">
                    <button name="rdg-leader-board-load-more" id="rdg-leader-board-load-more" class="<?php echo $disabled; ?>" <?php echo $disabled; ?>>Show More</button>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
