<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_SH_QUERY_POSTS];
    $block_query_posts = $rdgb->settings->getBlock(BLOCK_RDG_SH_QUERY_POSTS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $cpt_taxonomies = $block_query_posts->getPostTypeTaxonomies();
    $post_type = !empty(get_field('post_type')) ? get_field('post_type') : 'post';
    $show = !empty(get_field('show')) ? get_field('show') : 'latest';
    $category_type = !empty(get_field('select_category_type')) ? get_field('select_category_type') : '';
    $category_include = !empty(get_field('category_include')) ? implode(',', get_field('category_include')) : '';
    $category_include_array = !empty(get_field('category_include')) ? get_field('category_include') : '';
    $category_exclude = !empty(get_field('category_exclude')) ? implode(',', get_field('category_exclude')) : '';
    $category_exclude_array = !empty(get_field('category_exclude')) ? get_field('category_exclude') : '';
    $quantity = !empty(get_field('quantity')) ? get_field('quantity') : 0;

    $taxonomy = (isset($cpt_taxonomies['taxonomies'][$post_type])) ? $cpt_taxonomies['taxonomies'][$post_type] : '';

    $post_primary = null;
    $post_primary_class = 'size-primary-full';
    $post_list = null;
    $post_list_class = '';
    $elements = $block_query_posts->getElementsType(get_fields());

    if (is_array($elements) && count($elements) > 0) {
        $post_primary = $elements[0];
        unset($elements[0]);

        if (count($elements) > 0) {
            $post_list = $elements;
            $post_primary_class = 'size-primary';
            $post_list_class = 'size-posts-list';
        }
    }

    $cpt_game = $block_query_posts->getNameCptGame();
?>

<?php if ($post_primary !== null): ?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if ($show == 'latest'): ?>
            <section class="filter" data-post-type="<?php echo $post_type; ?>" data-taxonomy="<?php echo $taxonomy; ?>" data-show="<?php echo $show; ?>" data-category-type="<?php echo $category_type; ?>" data-category-include="<?php echo $category_include; ?>" data-category-exclude="<?php echo $category_exclude; ?>" data-quantity="<?php echo $quantity; ?>">
                <div class="search">
                    <input type="text" id="search" name="search" class="search" placeholder="SEARCH">
                </div>
                <div class="options">
                    <?php
                        if ($post_type == $cpt_game) {
                            require 'partials/filter_game.php';
                        } else {
                            require 'partials/filter_default.php';
                        }
                    ?>
                </div>
            </section>
            <section class="results"></section>
            <section class="posts-test"></section>
            <?php endif; ?>
            <div class="container-query-posts">
                <div class="query-primary <?php echo $post_primary_class; ?>">
                    <div class="query-post">
                        <?php
                            $link_url = '';
                            $link_target = '_self';
                            $link_name = 'Read more';
                            if ($post_primary instanceof WP_Post) {
                                $link_url = get_permalink($post_primary);
                            } else {
                                if (isset($post_primary['link_post']['url']) && !empty($post_primary['link_post']['url'])) {
                                    $link_url = $post_primary['link_post']['url'];
                                }

                                if (isset($post_primary['link_post']['target']) && !empty($post_primary['link_post']['target'])) {
                                    $link_target = $post_primary['link_post']['target'];
                                }

                                if (isset($post_primary['link_post']['title']) && !empty($post_primary['link_post']['title'])) {
                                    $link_name = $post_primary['link_post']['title'];
                                }
                            } 
                        ?>
                        <a class="post-link" href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>"></a>
                        <div class="post-image">
                            <?php
                                $image = '';
                                if ($post_primary instanceof WP_Post) {
                                    $image = $block_query_posts->getImage($post_primary->ID);
                                } else {
                                    if (isset($post_primary['image']['url']) && !empty($post_primary['image']['url'])) {
                                        $image = $post_primary['image']['url'];
                                    }
                                }
                            ?>

                            <?php if (!empty($image)): ?>
                                <img src="<?php echo $image; ?>" alt="Image">
                            <?php endif; ?>

                        </div>
                        <div class="post-content">
                            <div class="post-title">
                                <?php echo (!empty($post_primary->post_title)) ? $post_primary->post_title : $post_primary['title']; ?>
                            </div>
                            <div class="post-author">
                                <span class="author-icon">
                                    <svg width="16" height="18" viewBox="0 0 16 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13.9618 4.15202L11.3488 1.53752C10.8622 1.04862 10.2836 0.661015 9.64642 0.397112C9.00919 0.133208 8.32596 -0.00175791 7.63625 1.72865e-05H4.25C3.2558 0.00120818 2.30267 0.396679 1.59966 1.09968C0.896661 1.80269 0.501191 2.75582 0.5 3.75002V14.25C0.501191 15.2442 0.896661 16.1973 1.59966 16.9004C2.30267 17.6034 3.2558 17.9988 4.25 18H11.75C12.7442 17.9988 13.6973 17.6034 14.4003 16.9004C15.1033 16.1973 15.4988 15.2442 15.5 14.25V7.86377C15.5019 7.17408 15.3669 6.49089 15.1028 5.85375C14.8388 5.21661 14.4509 4.6382 13.9618 4.15202ZM12.9012 5.21252C13.1303 5.44813 13.3272 5.71291 13.487 6.00002H10.25C10.0511 6.00002 9.86032 5.921 9.71967 5.78035C9.57902 5.63969 9.5 5.44893 9.5 5.25002V2.01302C9.7872 2.17271 10.0522 2.36939 10.2882 2.59802L12.9012 5.21252ZM14 14.25C14 14.8468 13.7629 15.4191 13.341 15.841C12.919 16.263 12.3467 16.5 11.75 16.5H4.25C3.65326 16.5 3.08097 16.263 2.65901 15.841C2.23705 15.4191 2 14.8468 2 14.25V3.75002C2 3.15328 2.23705 2.58098 2.65901 2.15903C3.08097 1.73707 3.65326 1.50002 4.25 1.50002H7.63625C7.75925 1.50002 7.8785 1.52402 8 1.53527V5.25002C8 5.84675 8.23705 6.41905 8.65901 6.84101C9.08097 7.26296 9.65326 7.50002 10.25 7.50002H13.9647C13.976 7.62152 14 7.74002 14 7.86377V14.25Z" fill="#0160AC"/>
                                    </svg>
                                </span>
                                <?php
                                    $author_name = '';
                                    $author_url = '';
                                    $month = '';
                                    $more_date = '';
                                    $date = (!empty($post_primary->post_date)) ? $post_primary->post_date : $post_primary['date'];

                                    if (isset($post_primary->post_author)) {
                                        $author_name = get_the_author_meta('display_name', $post_primary->post_author);
                                        $author_url = get_author_posts_url($post_primary->post_author);
                                    }

                                    try {
                                        $d = DateTime::createFromFormat('Y-m-d H:i:s', $date);
                                        $date_status = $d && $d->format('Y-m-d H:i:s') == $date;

                                        if ($date_status) {
                                            $month = $d->format('F');
                                            $more_date = $d->format('j, Y');
                                            $date = $month.' '.$more_date;
                                        }
                                    } catch (\Exception $exception) {
                                        //
                                    }
                                ?>

                                <span class="author-date"><?php echo __($month, 'rdg-blocks-months').' '.$more_date; ?></span>
                                <?php if ($show != 'external'): ?>
                                    <?php if (!empty($author_name) || !empty($author_url)): ?>
                                        <span class="author-by"><?php echo __('By', 'rdg-blocks-sh-query-posts'); ?></span>
                                        <span class="author-name"><a href="<?php echo $author_url; ?>"><?php echo ucfirst($author_name); ?></a></span>
                                    <?php endif; ?>
                                    <?php $term = $block_query_posts->getTaxonomy($post_primary); ?>
                                    <?php if ($term !== null): ?>
                                        <span class="author-separator">|</span>
                                        <span class="post-categories">
                                            <span class="post-category">
                                                <a href="/<?php echo $term->taxonomy.'/'.$term->slug; ?>/"><?php echo $term->name; ?></a>
                                            </span>
                                        </span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <div class="post-description">
                                <?php
                                    $content = '';
                                    if ($post_primary instanceof WP_Post) {
                                        $content = $post_primary->post_content;
                                    } else {
                                        if (isset($post_primary['content']) && !empty($post_primary['content'])) {
                                            $content = $post_primary['content'];
                                        }
                                    }

                                    $description = $block_query_posts->getContentDescription($content);
                                ?>
                                <?php if (!empty($description)): ?>
                                    <?php echo trim(wp_trim_words($description, 120, false)); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if (is_array($post_list) && count($post_list) > 0): ?>
                    <div class="query-lists  <?php echo $post_list_class; ?>">
                        <?php foreach ($post_list as $post): ?>
                            <div class="query-post">
                                <?php
                                    $link_url = '';
                                    $link_target = '_self';
                                    $link_name = 'Read more';
                                    if ($post instanceof WP_Post) {
                                        $link_url = get_permalink($post);
                                    } else {
                                        if (isset($post['link_post']['url']) && !empty($post['link_post']['url'])) {
                                            $link_url = $post['link_post']['url'];
                                        }

                                        if (isset($post['link_post']['target']) && !empty($post['link_post']['target'])) {
                                            $link_target = $post['link_post']['target'];
                                        }

                                        if (isset($post['link_post']['title']) && !empty($post['link_post']['title'])) {
                                            $link_name = $post['link_post']['title'];
                                        }
                                    } 
                                ?>
                                <a class="post-link" href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>"></a>
                                <div class="post-image">
                                    <?php
                                        $image = '';
                                        if ($post instanceof WP_Post) {
                                            $image = $block_query_posts->getImage($post->ID);
                                        } else {
                                            if (isset($post['image']['url']) && !empty($post['image']['url'])) {
                                                $image = $post['image']['url'];
                                            }
                                        }
                                    ?>

                                    <?php if (!empty($image)): ?>
                                        <img src="<?php echo $image; ?>" alt="Image">
                                    <?php endif; ?>
                                </div>
                                <div class="post-content">
                                    <div class="post-title">
                                        <?php echo (!empty($post->post_title)) ? $post->post_title : $post['title']; ?>
                                    </div>
                                    <div class="post-author">
                                        <span class="author-icon">
                                            <svg width="16" height="18" viewBox="0 0 16 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M13.9618 4.15202L11.3488 1.53752C10.8622 1.04862 10.2836 0.661015 9.64642 0.397112C9.00919 0.133208 8.32596 -0.00175791 7.63625 1.72865e-05H4.25C3.2558 0.00120818 2.30267 0.396679 1.59966 1.09968C0.896661 1.80269 0.501191 2.75582 0.5 3.75002V14.25C0.501191 15.2442 0.896661 16.1973 1.59966 16.9004C2.30267 17.6034 3.2558 17.9988 4.25 18H11.75C12.7442 17.9988 13.6973 17.6034 14.4003 16.9004C15.1033 16.1973 15.4988 15.2442 15.5 14.25V7.86377C15.5019 7.17408 15.3669 6.49089 15.1028 5.85375C14.8388 5.21661 14.4509 4.6382 13.9618 4.15202ZM12.9012 5.21252C13.1303 5.44813 13.3272 5.71291 13.487 6.00002H10.25C10.0511 6.00002 9.86032 5.921 9.71967 5.78035C9.57902 5.63969 9.5 5.44893 9.5 5.25002V2.01302C9.7872 2.17271 10.0522 2.36939 10.2882 2.59802L12.9012 5.21252ZM14 14.25C14 14.8468 13.7629 15.4191 13.341 15.841C12.919 16.263 12.3467 16.5 11.75 16.5H4.25C3.65326 16.5 3.08097 16.263 2.65901 15.841C2.23705 15.4191 2 14.8468 2 14.25V3.75002C2 3.15328 2.23705 2.58098 2.65901 2.15903C3.08097 1.73707 3.65326 1.50002 4.25 1.50002H7.63625C7.75925 1.50002 7.8785 1.52402 8 1.53527V5.25002C8 5.84675 8.23705 6.41905 8.65901 6.84101C9.08097 7.26296 9.65326 7.50002 10.25 7.50002H13.9647C13.976 7.62152 14 7.74002 14 7.86377V14.25Z" fill="#0160AC"/>
                                            </svg>
                                        </span>
                                        <?php
                                            $date = (!empty($post->post_date)) ? $post->post_date : $post['date'];

                                            try {
                                                $d = DateTime::createFromFormat('Y-m-d H:i:s', $date);
                                                $date_status = $d && $d->format('Y-m-d H:i:s') == $date;

                                                if ($date_status) {
                                                    $month = $d->format('F');
                                                    $more_date = $d->format('j, Y');
                                                    $date = $month.' '.$more_date;
                                                }
                                            } catch (\Exception $exception) {
                                                //
                                            }

                                            $author_name = '';
                                            $author_url = '';
                                            if (isset($post->post_author)) {
                                                $author_name = get_the_author_meta('display_name', $post->post_author);
                                                $author_url = get_author_posts_url($post->post_author);
                                            }
                                        ?>

                                        <span class="author-date"><?php echo __($month, 'rdg-blocks-months').' '.$more_date; ?></span>
                                        <?php if ($show != 'external'): ?>
                                            <?php if (!empty($author_name) || !empty($author_url)): ?>
                                                <span class="author-by"><?php echo __('By', 'rdg-blocks-sh-query-posts'); ?></span>
                                                <span class="author-name"><a href="<?php echo $author_url; ?>"><?php echo ucfirst($author_name); ?></a></span>
                                            <?php endif; ?>
                                            <?php $term = $block_query_posts->getTaxonomy($post); ?>
                                            <?php if ($term !== null): ?>
                                                <span class="author-separator">|</span>
                                                <span class="post-categories">
                                                    <span class="post-category">
                                                        <a href="/<?php echo $term->taxonomy.'/'.$term->slug; ?>/"><?php echo $term->name; ?></a>
                                                    </span>
                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="post-description">
                                        <?php
                                            $content = '';
                                            if ($post instanceof WP_Post) {
                                                $content = $post->post_content;
                                            } else {
                                                if (isset($post['content']) && !empty($post['content'])) {
                                                    $content = $post['content'];
                                                }
                                            }

                                            $description = $block_query_posts->getContentDescription($content);
                                        ?>
                                        <?php if (!empty($description)): ?>
                                            <?php echo trim(wp_trim_words($description, 120, false)); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php endif; ?>