<?php

namespace Rdgcorp\MasterFeed\Application;

use Rdgcorp\MasterFeed\Infrastructure\MasterFeedClient;

class GetDirectSeasons
{
    private MasterFeedClient $masterFeedClient;

    public function __construct(MasterFeedClient $masterFeedClient)
    {
        $this->masterFeedClient = $masterFeedClient;
    }

    public function __invoke(?string $leagueId = null): array
    {
        $responseData = $this->masterFeedClient->getDirectSeasons($leagueId);

        return $responseData[0]['data-content'][0][0]['seasons'];
    }
}
