<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SINGLE_TOP_HANDICAPPERS;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    // Variables
    $columns = get_field('columns');

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
            
            <?php if (!empty($columns) && is_array($columns) && count($columns) > 0): ?>
                <div class="columns">
                    <?php foreach($columns as $column):?>
                        <div class="column">
                            <?php if (!empty($column['title'])): ?>
                                <div class="column-header">
                                    <span><?php echo $column['title'];?></span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (is_array($column['picks']) && count($column['picks']) > 0): ?>
                                <div class="picks">
                                    <?php foreach($column['picks'] as $pick):?>
                                        <div class="pick">
                                            <div class="content">
                                                <div class="center-header">
                                                    <div class="pick-header">
                                                        <div class="header-avatar">
                                                            <?php if (isset($pick['logo']['url']) && !empty($pick['logo']['url'])): ?>
                                                                <img src="<?php echo $pick['logo']['url']; ?>" alt="">
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="header-content <?php echo $pick['type_pick']; ?>">
                                                            <span class="title"><?php echo $pick['title']; ?></span>
                                                            <span class="sub-title"><?php echo $pick['sub_title']; ?></span>
                                                            <span class="total"><?php echo $pick['total']; ?>
                                                                <span class="picks"><?php echo $pick['picks']; ?></span>
                                                            </span>
                                                            <span class="score"><?php echo $pick['score']; ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="picks-available">
                                                    <span><?php echo $pick['pick_available']; ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($column['link'])): ?>
                                <div class="pick-footer">
                                    <span><a href="<?php echo $column['link']['url'];?>" target="<?php echo $column['link']['target'];?>"><?php echo $column['link']['title'];?></a></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
