<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '" style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_AV_PICKS_STICKY;
    $block_classes = [$block_name];
    $block_av_picks_sticky = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    // Get ACF fields
    $bar_background_color = get_field('bar_background_color');
    $disable_sticky = get_field('disable_sticky');
    $button_theme = get_field('button_theme');
    $hide_zero_picks = get_field('hide_zero_picks');
    $links_behavior = get_field('links_behavior');
    
    // Get options page fields
    $picks_admin_url = get_field('av_picks_sticky_picks_admin_url', 'option');
    
    // Apply bar background color if set
    if (!empty($bar_background_color)) {
        $block_styles[] = 'background-color: '.$bar_background_color.';';
    }
    
    // Add sticky class if not disabled
    if (!$disable_sticky) {
        $block_classes[] = 'sticky_top';
    }
    
    // Add button theme class
    if (!empty($button_theme)) {
        $block_classes[] = 'button-theme-' . $button_theme;
    }
    
    // Get API data
    $api_data = null;
    $api_attributes = $block_av_picks_sticky->getApiAttributes();
    
    if (!empty($api_attributes['request'])) {
        $response = $rdgb->helpers->getApiRequest(
            $api_attributes['request'],
            $api_attributes['method'],
            $api_attributes['headers']
        );
        
        if ($response['http_code'] == 200) {
            $api_data = $rdgb->helpers->isJson($response['data']);
        } else {
            error_log(sprintf('%s / %s: API request failed with HTTP code %s', RDGBLOCKS_NAME, $block_name, $response['http_code']));
        }
    }
    
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div id="rdg-sticky-picks-bar" class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
    <div class="rdg-sticky-picks-close-btn"></div>
    <div class="container content grid-container">
        <div class="custom-header-sports-nav">
            <?php if ($api_data && is_array($api_data)): ?>
                <?php $count = 0; ?>
                <?php foreach ($api_data as $sport_key => $sport_data): ?>
                    <?php 
                        // Skip if sport_data is not an array or doesn't have required fields
                        if (!is_array($sport_data) || !isset($sport_data['pick_count'])) {
                            continue;
                        }
                        
                        $pick_count = intval($sport_data['pick_count']);
                        
                        // Hide zero picks if the field is enabled
                        if ($hide_zero_picks && $pick_count === 0) {
                            continue;
                        }
                        
                        $count++;
                        $league_ids = isset($sport_data['league_ids']) && is_array($sport_data['league_ids']) ? $sport_data['league_ids'] : [];
                        $league_id = !empty($league_ids) ? $league_ids[0] : '';
                        
                        // Use sport key as display name (exactly as it comes from API)
                        $sport_name = $sport_key;
                        
                        // Build URL - prepend picks admin URL if set
                        $url_path = '/games/today/';
                        if (!empty($league_id)) {
                            $url_path .= $league_id;
                        }
                        
                        $url = !empty($picks_admin_url) ? rtrim($picks_admin_url, '/') . $url_path : $url_path;
                        
                        // Set target attribute based on links behavior
                        $target = ($links_behavior === 'blank') ? '_blank' : '_self';
                    ?>
                    <?php if ($count === 1) : ?>
                        <div id="rdg-sticky-picks-expand-btn">View More Picks</div>
                    <?php endif; ?>  
                    <a href="<?php echo esc_url($url); ?>" target="<?php echo esc_attr($target); ?>" class="custom-header-sport-btn <?php echo ($count === 1) ? 'first-btn' : ''; ?>" title="<?php echo esc_attr($sport_name); ?>">                            
                        <div class="custom-header-sport-info">
                            <span class="custom-header-sport-name"><?php echo esc_html($sport_name); ?></span>
                            <span class="custom-header-sport-picks"><?php echo esc_html($pick_count); ?> Picks</span>
                        </div>
                    </a>                      
                <?php endforeach; ?>
            <?php else: ?>
                <!-- No data available or API error -->
                <p>No picks data available at this time.</p>
            <?php endif; ?>
        </div>
    </div>
</div>
