<div class="cappers">
    <div class="capper">
        <div class="capper-header">
            <div class="title">
                <span class="header-title">
                    <?php echo (!empty($title)) ? $title.' - ' : ''; ?>
                    <?php echo __($block_top_cappers->get_title($period), 'rdg-blocks-top-cappers'); ?>
                </span>
            </div>
        </div>
        <div class="capper-body">
            <?php if (isset($cappers[0]['image'])): ?>
                <?php
                    $capper_image = $block_top_cappers->get_image($cappers[0]['image'], [
                        'image_type' => 'top_capper',
                        'image_alt' => $cappers[0]['handicapper'],
                        'logo_label' => false,
                    ]);
                ?>
                <div class="logo">
                    <img src="<?php echo $capper_image['url']; ?>" alt="<?php echo $capper_image['alt']; ?>">
                </div>
            <?php endif; ?>

            <?php if (!empty($cappers[0]['handicapper'])): ?>
                <div class="name">
                    <span><?php echo $cappers[0]['handicapper']; ?></span>
                </div>
            <?php endif; ?>

            <?php if (!empty($cappers[0]['net'])): ?>
                <div class="score separator">
                    <span>$<?php echo number_format($cappers[0]['net'], 0, '.', ','); ?></span>
                </div>
            <?php endif; ?>

            <?php if (count($cappers) > 1): ?>
                <div class="scores">
                    <?php $i = 2; ?>
                    <?php array_shift($cappers); ?>
                    <?php $fields = $block_top_cappers->get_fields_validate(); ?>
                    <?php foreach($cappers as $capper):?>
                        <?php if (!$rdgb->helpers->validate_fields($fields, $capper)) continue; ?>
                        <div class="score separator">
                            <div class="score-name"><?php echo $i.'. '.$capper['handicapper'] ?></div>
                            <div class="score-score">$<?php echo number_format($capper['net'], 0, '.', ','); ?></div>
                        </div>
                        <?php $i++; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>