<?php
    // Get number of items from block configuration
    $total_items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;
    
    // Navigate the nested structure correctly:
    // $cappers['Sports']['Baseball'][0..n]
    $sport_data = $cappers['Sports']; // ['Baseball' => [...]]
    $sport_name = array_key_first($sport_data); // 'Baseball', 'Basketball', etc.
    $cappers_list = $sport_data[$sport_name]; // [0 => capper1, 1 => capper2, ...]
    
    // Get the requested number of cappers
    $selected_cappers = array_slice($cappers_list, 0, $total_items);
    
    // First capper (featured)
    $first_cappers = $selected_cappers[0];
    
    // Remaining cappers (for the list below)
    $remaining_cappers = array_slice($selected_cappers, 1);
    
    $group_name = (!empty($first_cappers['group_name'])) ? $first_cappers['group_name'] : HANDICAPPER_PACKAGE_DEFAULT;
?>

<div class="cappers">
<?php if ($theme === 'regular'): ?>
    <div class="capper">
        <div class="capper-header">
            <div class="title">
                <span class="header-title">
                    <?php echo (!empty($title)) ? $title : ''; ?>
                </span>
            </div>
        </div>
        <div class="capper-body">
            <?php if (isset($first_cappers['image'])): ?>
                <?php
                    $capper_image = $block_top_cappers_sport->get_image($first_cappers['image'], [
                        'image_type' => 'top_capper',
                        'image_alt' => $first_cappers['name'],
                        'logo_label' => false,
                    ]);
                ?>
                <div class="logo">
                    <img src="<?php echo $capper_image['url']; ?>" alt="<?php echo $capper_image['alt']; ?>">
                </div>
            <?php endif; ?>

            <?php if (!empty($first_cappers['name'])): ?>
                <div class="name">
                    <span><?php echo $first_cappers['name']; ?></span>
                </div>
            <?php endif; ?>

            <?php if (!empty($first_cappers['Net'])): ?>
                <div class="score separator">
                    <span>$<?php echo number_format($first_cappers['Net'], 0, '.', ','); ?></span>
                </div>
            <?php endif; ?>

            <?php if (!empty($remaining_cappers) && is_array($remaining_cappers) && count($remaining_cappers) > 0): ?>
                <div class="scores">
                    <?php $i = 2; ?>
                    <?php $fields = $block_top_cappers_sport->getFieldsValidate(); ?>
                    <?php foreach($remaining_cappers as $capper):?>
                        <?php if (!$rdgb->helpers->validateFields($fields, $capper)) continue; ?>
                        <div class="score separator">
                            <div class="score-name"><?php echo $i.'. '.$capper['name'] ?></div>
                            <div class="score-score">$<?php echo number_format($capper['Net'], 0, '.', ','); ?></div>
                        </div>
                        <?php $i++; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php else: ?>
    <div class="capper-inline">
        <div class="capper-body">
            <?php if (isset($first_cappers['image'])): ?>
                <?php
                    $capper_image = $block_top_cappers_sport->get_image($first_cappers['image'], [
                        'image_type' => 'top_capper',
                        'image_alt' => $first_cappers['name'],
                        'logo_label' => false,
                    ]);
                ?>
                <div class="logo">
                    <img src="<?php echo $capper_image['url']; ?>" alt="<?php echo $capper_image['alt']; ?>">
                </div>
            <?php endif; ?>

            <div class="capper-info">
                <?php if (!empty($first_cappers['name'])): ?>
                    <div class="name">
                        <span><?php echo $first_cappers['name']; ?></span>
                    </div>
                <?php endif; ?>
                <div class="package">
                    <span><?php echo $group_name; ?></span>
                </div>
                <div class="profit">
                    <span>Won in the last <?php echo $days; ?> days: $<?php echo number_format($first_cappers['WinAmount'], 0, '.', ','); ?></span>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
</div>