<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Sh_Youtube_Video extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SH_YOUTUBE_VIDEO;
    private $block_folder_name = 'sh-youtube-video';
    protected $block_title = 'SH Youtube Video';
    private $block_description = 'Add lazy-loading YouTube videos to page o post';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'sh', 'video', 'youtube', 'lazy'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_sh_youtube_video.css'),
                'enqueue_assets' => function() {
                    wp_enqueue_style('sh_youtube_video_styles');
                    wp_enqueue_script('lazyframe_local', RDGBLOCKS_PLUGIN_URL . 'blocks/sh-youtube-video/assets/js/libs/lazyframe.min.js', [], null, true);
                    wp_register_script('rdg_sh_youtube_video_script', RDGBLOCKS_PLUGIN_URL.'blocks/sh-youtube-video/assets/js/sh-youtube-video.js', ['lazyframe_local'], '1', true);
                    wp_enqueue_script('rdg_sh_youtube_video_script');
                },
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-sh-youtube-video-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'render_callback' => function($block) use ($rdg_helpers) {
                    global $wp_query;
                    $loop = $wp_query->in_the_loop;
                    $template_path = RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php";

                    if ($loop) {
                        include $template_path;
                        return;
                    }

                    $trace_config = $rdg_helpers->getBacktraceConfig();
                    $traces = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, $trace_config['max_trace']);
                    $trace_valid_admin = $rdg_helpers->checkExistsTraceFunction($traces, $trace_config['max_trace'], $trace_config['functions']);

                    if (is_admin() && !$trace_valid_admin) {
                        include $template_path;
                        return;
                    }
                },
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_sh_youtube_video',
                'title' => 'rdg_sh_youtube_video',
                'fields' => array(
                    array(
                        "key" => "key_sh_youtube_video_videos",
                        "label" => "Videos",
                        "name" => "sh_youtube_video_videos",
                        "aria-label" => "",
                        "type" => "repeater",
                        "instructions" => "",
                        "required" => 0,
                        "conditional_logic" => 0,
                        "wrapper" => array(
                            "width" => "",
                            "class" => "",
                            "id" => ""
                        ),
                        "acfe_repeater_stylised_button" => 0,
                        "layout" => "block",
                        "pagination" => 0,
                        "min" => 0,
                        "max" => 0,
                        "collapsed" => "",
                        "button_label" => "Add Row",
                        "rows_per_page" => 20,
                        'sub_fields' => array(
                            array(
                                "key" => "key_sh_youtube_video_url",
                                "label" => "Url",
                                "name" => "sh_youtube_video_url",
                                "aria-label" => "",
                                "type" => "url",
                                "instructions" => "",
                                "required" => 1,
                                "conditional_logic" => 0,
                                "wrapper" => array(
                                    "width" => "",
                                    "class" => "",
                                    "id" => ""
                                ),
                                "default_value" => "",
                                "allow_in_bindings" => 0,
                                "placeholder" => "",
                                "parent_repeater" => "key_sh_youtube_video_videos"
                            ),
                            array(
                                'key' => 'key_sh_youtube_video_width',
                                'label' => 'Width (%)',
                                'name' => 'sh_youtube_video_width',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 30,
                                'max' => 100,
                                'placeholder' => 'min: 30, max: 100',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                "key" => "key_sh_youtube_video_place_holder_image",
                                "label" => "Place Holder Image",
                                "name" => "place_holder_image",
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'key_sh_youtube_video_videos',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/sh-youtube-video',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-sh-youtube-video-title','slug' => 'color-rdg-sh-youtube-video-title','color' => '#eee'],
            ['name' => 'color-rdg-sh-youtube-video-title-hover','slug' => 'color-rdg-sh-youtube-video-title-hover','color' => '#fff'],
            ['name' => 'color-rdg-sh-youtube-video-background','slug' => 'color-rdg-sh-youtube-video-background','color' => '#ff0000'],            
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-blocks .content .sh-youtube-video .videos .video .lazyframe',
                'fontFamily' => 'Roboto, Arial, Helvetica, sans-serif',
                'fontSize' => '1.2rem',
            ]
        ];
    }
}

$rdg_sh_youtube_video = new Rdg_Blocks_Sh_Youtube_Video();
$rdg_sh_youtube_video->init();

return $rdg_sh_youtube_video;
