<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_ADMIN_CAPPERS_SIMPLE;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : $block['id'];

    $cache = new Rdg_Blocks_Cache();
    $connect = $cache->getRedisConnect();
    if (!$connect) {
        error_log(sprintf('%s / %s: Redis connection failed.', RDGBLOCKS_NAME, $block_name));
        return;
    }

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $cappers = get_field('cappers');
    $category = get_field('category');
    $links = get_field('links');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $source = get_field('source');
    $show = (!empty(get_field('show_in'))) ? get_field('show_in') : 'full';
    $link_options = (!empty(get_field('link_options'))) ? get_field('link_options') : 'none';
    $custom_link = (!empty(get_field('custom_link'))) ? get_field('custom_link') : null;
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;
    $date_request = $block_admin_cappers->get_date_filter($date_type, $since_date, $to_date);
    $titles_sports = $rdgb->helpers->getSporstCategoriesTitles(true);

    $items = null;
    $cache_name = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);

    if ($source == 'api' && $block_admin_cappers->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            // Normalize API response to handle hierarchy-wrapped format
            $reflection = new ReflectionClass($block_admin_cappers);
            $method = $reflection->getMethod('normalizeApiResponse');
            $method->setAccessible(true);
            $cappers = $method->invoke($block_admin_cappers, $cache_block_array['api_response']);
            $items = $cache_block_array['items'];
        }
    }
?>

<?php if (is_array($cappers) && count($cappers) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_admin_cappers->getLogDebug($params);
        ?>
        <div <?php echo (!empty($block_id)) ? 'id="'.$block_id.'"' : ''; ?> class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $show; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

                <div class="cappers">
                    <?php
                        if ($source == 'api') {
                            require 'partials/api.php';
                        } else {
                            require 'partials/manual.php';
                        }
                    ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
