<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Pros_Cons extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PROS_CONS;
    private $block_folder_name = 'rdg-pros-cons';
    protected $block_title = 'RDG Pros and Cons';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'pro', 'con'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_pros_cons.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_pros_cons_block_sdasdarwrvwx',
                'title' => 'Block_rdg_pros_cons',
                'fields' => array(
                    array(
                        'key' => 'field_643ef3450a683',
                        'label' => 'Verified',
                        'name' => 'verified',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hide' => 'Hide',
                            'show' => 'Show',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_643ef3e20a684',
                        'label' => 'Image',
                        'name' => 'image',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_643ef3450a683',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_643ef4050a685',
                        'label' => 'Date',
                        'name' => 'date',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_643ef3450a683',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_643ef44d0a686',
                        'label' => 'Image Site',
                        'name' => 'image_site',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_643ef46b0a687',
                        'label' => 'Features',
                        'name' => 'features',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_643ef4810a688',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                            array(
                                'key' => 'field_643ef49b0a689',
                                'label' => 'Heading',
                                'name' => 'heading',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'h2' => 'H2',
                                    'h3' => 'H3',
                                    'h4' => 'H4',
                                    'h5' => 'H5',
                                    'span' => 'Span',
                                ),
                                'default_value' => 'span',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                            array(
                                'key' => 'field_643ef50c0a68c',
                                'label' => 'Size',
                                'name' => 'size',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 1,
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                            array(
                                'key' => 'field_643ef4ca0a68a',
                                'label' => 'Padding',
                                'name' => 'padding',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                            array(
                                'key' => 'field_643ef4e10a68b',
                                'label' => 'Weight',
                                'name' => 'weight',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    100 => '100',
                                    200 => '200',
                                    300 => '300',
                                    400 => '400',
                                    500 => '500',
                                    600 => '600',
                                    700 => '700',
                                    800 => '800',
                                    900 => '900',
                                ),
                                'default_value' => 400,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                            array(
                                'key' => 'field_643ef5610a68d',
                                'label' => 'Color',
                                'name' => 'color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#111111',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                            array(
                                'key' => 'field_643fe7f252420',
                                'label' => 'Items Style',
                                'name' => 'style_elements',
                                'aria-label' => '',
                                'type' => 'group',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64400e1196e8c',
                                        'label' => 'Icon',
                                        'name' => 'list_style',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'check' => 'Check',
                                            'chevron' => 'Chevron Right',
                                            'dot' => 'Dot',
                                            'circle' => 'Dot Circle',
                                            'close' => 'X Circle',
                                        ),
                                        'default_value' => 'check',
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                    ),
                                    array(
                                        'key' => 'field_643fe80b52421',
                                        'label' => 'Heading',
                                        'name' => 'heading',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'h2' => 'H2',
                                            'h3' => 'H3',
                                            'h4' => 'H4',
                                            'h5' => 'H5',
                                            'span' => 'Span',
                                        ),
                                        'default_value' => 'span',
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                    ),
                                    array(
                                        'key' => 'field_643fe83352422',
                                        'label' => 'Size',
                                        'name' => 'size',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 1,
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                    ),
                                    array(
                                        'key' => 'field_643fe83a52423',
                                        'label' => 'Padding',
                                        'name' => 'padding',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 0,
                                        'min' => 0,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                    ),
                                    array(
                                        'key' => 'field_643fe84852424',
                                        'label' => 'Weight',
                                        'name' => 'weight',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            100 => '100',
                                            200 => '200',
                                            300 => '300',
                                            400 => '400',
                                            500 => '500',
                                            600 => '600',
                                            700 => '700',
                                            800 => '800',
                                            900 => '900',
                                        ),
                                        'default_value' => 400,
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                    ),
                                    array(
                                        'key' => 'field_643fe85352425',
                                        'label' => 'Text Color',
                                        'name' => 'text_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#111111',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                    ),
                                    array(
                                        'key' => 'field_643feb6ad60c3',
                                        'label' => 'Icon Color',
                                        'name' => 'icon_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#111111',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                    ),
                                ),
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                            array(
                                'key' => 'field_643ef63b21cba',
                                'label' => 'Items',
                                'name' => 'elements',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_643ef63b21cbb',
                                        'label' => 'Text',
                                        'name' => 'text',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643ef63b21cba',
                                    ),
                                ),
                                'parent_repeater' => 'field_643ef46b0a687',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-pros-cons',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($fields, $type) {
        $style = [];

        if ($type == 'heading') {
            $style[] = (!empty($fields['size'])) ? 'font-size:'.$fields['size'].'rem' : 'font-size:1rem';
            $style[] = (!empty($fields['size'])) ? 'line-height:'.$fields['size'].'rem' : 'line-height:1rem';
            $style[] = (!empty($fields['padding'])) ? 'margin-bottom:'.$fields['padding'].'rem' : 'margin-bottom:0';
            $style[] = (!empty($fields['weight'])) ? 'font-weight:'.$fields['weight'] : 'font-weight:400';
            $style[] = (!empty($fields['color'])) ? 'color:'.$fields['color'] : 'color:#111111';

            return implode('; ', $style).';';
        }

        if ($type == 'items') {
            $style[] = (!empty($fields['style_elements']['size'])) ? '--item-size:'.$fields['style_elements']['size'].'rem' : '--item-size:1rem';
            $style[] = (!empty($fields['style_elements']['size'])) ? '--line-height:'.$fields['style_elements']['size'].'rem' : '--line-height:1rem';
            $style[] = (!empty($fields['style_elements']['padding'])) ? 'margin-bottom:'.$fields['style_elements']['padding'].'rem' : 'margin-bottom:0';
            $style[] = (!empty($fields['weight'])) ? '--item-weight:'.$fields['style_elements']['weight'] : '--item-weight:400';
            $style[] = (!empty($fields['style_elements']['text_color'])) ? 'color:'.$fields['style_elements']['text_color'] : 'color:#111111';
            $style[] = (!empty($fields['style_elements']['icon_color'])) ? '--list-color:'.$fields['style_elements']['icon_color'] : '--list-color:#111111';

            return implode('; ', $style).';';
        }
        
        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-pros-cons-verified','slug' => 'color-pros-cons-verified','color' => '#00bc00'],
            ['name' => 'color-pros-cons-date','slug' => 'color-pros-cons-date','color' => '#555'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-pros-cons .review .verified .label',
                'fontWeight' => '600',
                'fontSize' => '1.1rem',
            ],
            [
                'customSelector' => '.rdg-pros-cons .review .verified .date',
                'fontWeight' => '600',
                'fontSize' => '1.1rem',
            ],
        ];
    }
}

$rdg_pros_cons_class = new Rdg_Blocks_Pros_Cons();
$rdg_pros_cons_class->init();

return $rdg_pros_cons_class;
