<?php

namespace Rdgcorp\MasterFeed\Infrastructure;

use Symfony\Component\HttpClient\HttpClient;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class MasterFeedClient
{
    private HttpClientInterface $httpClient;

    private string $token;

    public function __construct(string $token)
    {
        $this->httpClient = HttpClient::create();
        $this->token = $token;
    }

    public function getDirectSports(): array
    {
        $response = $this->httpClient->request('GET', 'http://masterfeed.shnadmin.com/feed/sportdirect/sports', [
            'query' => ['key' => $this->token],
        ]);

        if (200 !== $response->getStatusCode()) {
            throw new \Exception(json_encode([
                'statusCode' => $response->getStatusCode(),
                'response' => $response->toArray(false),
            ]));
        }

        return $response->toArray();
    }

    public function getDirectLeagues(): array
    {
        $response = $this->httpClient->request('GET', 'http://masterfeed.shnadmin.com/feed/sportdirect/leagues', [
            'query' => ['key' => $this->token],
        ]);

        if (200 !== $response->getStatusCode()) {
            throw new \Exception(json_encode([
                'statusCode' => $response->getStatusCode(),
                'response' => $response->toArray(false),
            ]));
        }

        return $response->toArray();
    }

    public function getDirectTeams(?string $sportId = null): array
    {
        $query = ['key' => $this->token];

        if ($sportId) {
            $query ['sport_id'] = $sportId;
        }

        $response = $this->httpClient->request('GET', 'http://masterfeed.shnadmin.com/feed/sportdirect/teams', [
            'query' => $query,
        ]);

        if (200 !== $response->getStatusCode()) {
            throw new \Exception(json_encode([
                'statusCode' => $response->getStatusCode(),
                'response' => $response->toArray(false),
            ]));
        }

        return $response->toArray();
    }

    public function getDirectSeasons(?string $leagueId = null): array
    {
        $query = ['key' => $this->token];

        if ($leagueId) {
            $query['league_id'] = $leagueId;
        }

        $response = $this->httpClient->request('GET', 'http://masterfeed.shnadmin.com/feed/sportdirect/seasons', [
            'query' => $query,
        ]);

        if (200 !== $response->getStatusCode()) {
            throw new \Exception(json_encode([
                'statusCode' => $response->getStatusCode(),
                'response' => $response->toArray(false),
            ]));
        }

        return $response->toArray();
    }

    public function getDirectSchedules(?string $teamId = null, ?string $seasonId = null): array
    {
        $query = ['key' => $this->token];

        if ($teamId) {
            $query['team_id'] = $teamId;
        }

        if ($seasonId) {
            $query['season_id'] = $seasonId;
        }

        $response = $this->httpClient->request('GET', 'http://masterfeed.shnadmin.com/feed/sportdirect/schedules', [
            'query' => $query,
        ]);

        if (200 !== $response->getStatusCode()) {
            throw new \Exception(json_encode([
                'statusCode' => $response->getStatusCode(),
                'response' => $response->toArray(false),
            ]));
        }

        return $response->toArray();
    }
}
