<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Quick_Links extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_QUICK_LINKS;
    private $block_folder_name = 'rdg-quick-links';
    protected $block_title = 'RDG Quick Links';
    private $block_description = 'The block is a card style list of items with the option to add a link and edit the title for the structure';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'quick', 'link'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_quick_links.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-quick-links-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_quick_links_block_sadw5adadsdadr',
                'title' => 'Block_rdg_quick_links',
                'fields' => array(
                    array(
                        'key' => 'field_6442cb97fb92b',
                        'label' => 'Title',
                        'name' => 'title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6442cb65e1a58',
                        'label' => 'Items',
                        'name' => 'items',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6442cbadfb92c',
                                'label' => 'Text',
                                'name' => 'text',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6442cb65e1a58',
                            ),
                            array(
                                'key' => 'field_6442cbb9fb92d',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_6442cb65e1a58',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-quick-links',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-quick-link-header-bg','slug' => 'color-quick-link-header-bg','color' => '#0160ac'],
            ['name' => 'color-quick-link-title','slug' => 'color-quick-link-title','color' => '#FFFFFF'],
            ['name' => 'color-quick-link-border','slug' => 'color-quick-link-border','color' => '#CCC'],
            ['name' => 'color-quick-link-item','slug' => 'color-quick-link-item','color' => '#0160ac'],
            ['name' => 'color-quick-link-li','slug' => 'color-quick-link-li','color' => '#00bb08'],
            ['name' => 'color-quick-link-a','slug' => 'color-quick-link-a','color' => '#0160ac'],
            ['name' => 'color-quick-link-a-hover','slug' => 'color-quick-link-a-hover','color' => '#3a96e0'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-quick-links .header .title',
                'fontWeight' => '700',
                'fontSize' => '1.2rem',
            ],
            [
                'customSelector' => '.rdg-quick-links .body li',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-quick-links .content .body li::marker',
                'fontSize' => '0.8rem',
            ],
        ];
    }
}

$rdg_quick_links_class = new Rdg_Blocks_Quick_Links();
$rdg_quick_links_class->init();

return $rdg_quick_links_class;
