<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_INJURY_REPORT;
    $block_classes = [$block_name];
    $block_injury_report = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : $block['id'];

    $cache = new Rdg_Blocks_Cache();
    $connect = $cache->getRedisConnect();
    if (!$connect) {
        error_log(sprintf('%s / %s: Redis connection failed.', RDGBLOCKS_NAME, $block_name));
        return;
    }

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $league = (!empty(get_field('rdg_injury_report_leagues'))) ? get_field('rdg_injury_report_leagues') : null;
    $team = (!empty(get_field('rdg_injury_report_teams'))) ? get_field('rdg_injury_report_teams') : null;
    $select_season = (!empty(get_field('rdg_injury_report_season'))) ? get_field('rdg_injury_report_season') : null;
    $items = (!empty(get_field('rdg_injury_report_items_per_page'))) ? get_field('rdg_injury_report_items_per_page') : 10;
    $season = $block_injury_report->getSeason($league, $select_season);

    $post_id = get_the_ID();
    $post_type = get_post_type($post_id);
    $cache_file = $rdgb->helpers->getCacheName($block_name, $post_type, $post_id, $block_id);
    $cache_file_valid = $rdgb->helpers->getCacheName($block_name, $post_type, $post_id, $block_id, true);

    $cache_name = null;
    $injuries = null;
    $api_attributes = null;

    if ($block_injury_report->isCaching() && !empty($block_id)) {
        $cache_name = $rdgb->helpers->getBlocksCacheName($block_name, $post_type, $post_id, $block_id);
        $cache_block = $cache->getCacheBlock($cache_name);
        $cache_block_array = $rdgb->helpers->isJson($cache_block);

        if ($cache_block_array && is_array($cache_block_array['api_response'])) {
            $api_attributes = $cache_block_array['api_attributes'];
            $injuries = isset($cache_block_array['api_response']) ? $cache_block_array['api_response'] : [];
        }
    }

    $filter_data = $block_injury_report->getSearchOptions($block_name, $post_type, $post_id, $block_id, true);
    $options_locations = (isset($filter_data['locations']) && !empty($filter_data['locations'])) ? $filter_data['locations'] : '';
    $options_status = (isset($filter_data['status']) && !empty($filter_data['status'])) ? $filter_data['status'] : '';
    $options_display_status = (isset($filter_data['display_status']) && !empty($filter_data['display_status'])) ? $filter_data['display_status'] : '';
?>

<?php if (is_array($injuries) && count($injuries) > 0): ?>
    <div class="rdg-blocks">
        <?php
            $params = ['cache_name' => $cache_name, 'api_request' => $api_attributes];
            $block_injury_report->getLogDebug($params);
            $debug_cache = $rdgb->helpers->rdgDebugCache($cache_file);
        ?>
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
                <?php
                if (count($injuries) > 3 && is_user_logged_in() && current_user_can('administrator')) {
                    $injuries = array_slice($injuries, 0, 3, true);
                }
                ?>
                <section class="filter" data-debug-cache="<?php echo $debug_cache;?>" data-current-page="1" data-items-per-page="<?php echo $items;?>" data-cache-file="<?php echo $cache_file;?>" data-block-name="<?php echo $block_name;?>" data-custom-id="<?php echo $block_id;?>" data-post-id="<?php echo $post_id;?>">
                    <div class="search">
                        <input type="text" id="search" name="search" class="search" placeholder="SEARCH">
                    </div>
                    <div class="options">
                        <select name="location" id="location">
                            <option value="">Location</option>
                            <?php echo $options_locations; ?>
                        </select>
                        <select name="status" id="status">
                            <option value="">Status</option>
                            <?php echo $options_status; ?>
                        </select>
                        <select name="display_status" id="display-status">
                            <option value="">Display Status</option>
                            <?php echo $options_display_status; ?>
                        </select>
                    </div>
                </section>
                <section class="results"></section>
                <div class="injuries">
                    <?php
                        $players = (function_exists('shMappingTeamPlayers')) ? shMappingTeamPlayers() : [];
                    ?>
                    <?php foreach ($injuries as $injury): ?>
                        <div class="injury">
                            <div class="player">
                                <span>
                                <?php
                                    if (is_user_logged_in() && current_user_can('administrator')) {
                                        echo sprintf('<b>Player:</b> %1$s', $rdgb->helpers->getPlayerName($injury['player_id'], $players));
                                    } else {
                                        echo sprintf('<b>Player:</b> %1$s', $injury['player_id']);
                                    }
                                ?>
                                </span>
                            </div>
                            <div class="content">
                                <span class="location">
                                    <?php echo sprintf('<b>Location:</b> %1$s', $injury['location']); ?>
                                </span>
                                <span class="start-date">
                                    <?php echo sprintf('<b>Start Date:</b> %1$s', $injury['start_date']); ?>
                                </span>
                                <span class="status">
                                    <?php echo sprintf('<b>Status:</b> %1$s', $injury['status']); ?>
                                </span>
                                <span class="display-status">
                                    <?php echo sprintf('<b>Display Status:</b> %1$s', $injury['display_status']); ?>
                                </span>
                            </div>
                            <div class="note">
                                <?php echo sprintf('<b>Note:</b> %1$s', $injury['note']); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <section class="pagination-result"></section>
                <section class="message">
                    <?php
                        if (is_user_logged_in() && current_user_can('administrator') && !file_exists($cache_file_valid)) {
                            echo '<span>It is necessary to save to generate the cache of the RDG Injury Report block.</span>';
                        } 
                    ?>
                </section>
            </div>
        </div>
    </div>
<?php endif; ?>
