<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Ranking_Bookie extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_RANKING_BOOKIE;
    private $block_folder_name = BLOCK_RDG_RANKING_BOOKIE;
    protected $block_title = 'RDG Ranking Bookie';
    private $block_description = 'With this block is possible to create a ranking structure with bookie name, subtitle, stars ranking and a description about it';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'ranking', 'bookie'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_ranking_bookie.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-ranking-bookie-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_ranking_bookie_block_sdaasdasd',
                'title' => 'Block_rdg_ranking_bookie',
                'fields' => array(
                    array(
                        'key' => 'field_64357d9e04efe',
                        'label' => 'Bookie',
                        'name' => 'bookie',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64357dfdfaf38',
                        'label' => 'Heading',
                        'name' => 'heading',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'h4' => 'H4',
                            'h5' => 'H5',
                            'span' => 'Span',
                        ),
                        'default_value' => 'h3',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64357e74faf39',
                        'label' => 'Sub Title',
                        'name' => 'sub_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64357e8afaf3a',
                        'label' => 'Ranking',
                        'name' => 'ranking',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 5,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64357eb3faf3b',
                        'label' => 'Description',
                        'name' => 'description',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'basic',
                        'media_upload' => 0,
                        'delay' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-ranking-bookie',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_stars(float $stars) {
        $fills = intval($stars);
        $half = ($stars - $fills == 0) ? 0 : 1;
        $emptys = 5 - $fills - $half;

        for ($i = 0; $i < $fills; $i++) {
            echo '<span class="star star-fill"></span>';
        }

        if ($half > 0) {
            echo '<span class="star star-half"></span>';
        }

        for ($i = 0; $i < $emptys; $i++) {
            echo '<span class="star star-empty"></span>';
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-ranking-bookie-title','slug' => 'color-ranking-bookie-title','color' => '#111111'],
            ['name' => 'color-ranking-bookie-ranking-since','slug' => 'color-ranking-bookie-ranking-since','color' => '#7f8c8d'],
            ['name' => 'color-ranking-bookie-description','slug' => 'color-ranking-bookie-description','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-ranking-bookie .ranking-title',
                'fontWeight' => '700',
                'fontSize' => '1.5rem',
            ],
            [
                'customSelector' => '.rdg-ranking-bookie .ranking-data .ranking-since',
                'fontWeight' => '500',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-ranking-bookie .content .ranking-description',
                'fontSize' => '1.1rem',
                'lineHeight' => '1.8rem',
            ],
        ];
    }
}

$rdg_ranking_bookie_class = new Rdg_Blocks_Ranking_Bookie();
$rdg_ranking_bookie_class->init();

return $rdg_ranking_bookie_class;
