<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Simple_Post_List extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SIMPLE_POST_LIST;
    private $block_folder_name = 'rdg-simple-post-list';
    protected $block_title = 'RDG Simple Post List';
    private $block_description = 'This block allow to create a card style section with info like a image, title, short description text and a link';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'simple post list'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_simple_post_list.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-simple-post-list-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_643a03b427a58',
                'title' => 'Simple Post List',
                'fields' => array(
                    array(
                        'key' => 'field_643a041091370',
                        'label' => 'Image',
                        'name' => 'image',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_643a03b99136f',
                        'label' => 'Title',
                        'name' => 'title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_643a044091371',
                        'label' => 'Content',
                        'name' => 'content',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                        'delay' => 0,
                    ),
                    array(
                        'key' => 'field_643a045191372',
                        'label' => 'Link',
                        'name' => 'link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-simple-post-list',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            
            endif;		
    }

    public function getColorsToloadGeneratePress()
    {
        return [
            ['name' => 'color-rdg-simple-post-list-column-bg','slug' => 'color-rdg-simple-post-list-column-bg','color' => '#ffffff'],
            ['name' => 'color-rdg-simple-post-list-title','slug' => 'color-rdg-simple-post-list-title','color' => '#0160ac'],
            ['name' => 'color-rdg-simple-post-list-button','slug' => 'color-rdg-simple-post-list-button','color' => '#0160ac'],
            ['name' => 'color-rdg-simple-post-list-button-border','slug' => 'color-rdg-simple-post-list-button-border','color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress()
    {
        return [
            [
                'customSelector' => '.rdg-simple-post-list .column .title',
                'fontSize' => '1.563rem',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.rdg-simple-post-list .column .description',
                'fontSize' => '1.125rem',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.rdg-simple-post-list .column .read-more a',
                'fontSize' => '1.125rem',
                'fontWeight' => '700',
                'textDecoration' => 'none',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-simple-post-list .column .read-more a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_previews_and_predictions_class = new Rdg_Blocks_Simple_Post_List ();
$rdg_previews_and_predictions_class->init();

return $rdg_previews_and_predictions_class;
