<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_CPT_LIST];
    $block_cpt_list = $rdgb->settings->get_block(BLOCK_RDG_CPT_LIST);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $fields_cpt = $block_cpt_list->get_fields_cpt(get_fields());
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $data = $block_cpt_list->get_elements_type($fields_cpt, $paged);

    if ($data instanceof WP_Query) {
        $num_pages = intval($data->found_posts / $fields_cpt['quantity']);
        $posts = $data->posts;

        if (($data->found_posts % $fields_cpt['quantity']) != 0) {
            $num_pages++;
        }
    } else {
        $num_pages = (is_array($data) && count($data) > 0) ? count($data) : 1;
        $posts = $data;
    }

    $cpt_active = false;
    $all_post_type = get_post_types([], 'names', 'and');
    if (is_array($all_post_type) && isset($all_post_type[$fields_cpt['cpt']])) {
        $cpt_active = true;
    }
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php if ($cpt_active): ?>
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

                <?php if (is_array($posts) && count($posts) > 0): ?>
                    <main class="posts">
                        <?php foreach($posts as $post): ?>
                            <article id="post post-<?php the_ID(); ?>">
                                <div class="inside-article">
                                    <div class="article-header">
                                        <div class="article-date">
                                            <?php echo date('F j, Y', strtotime($post->post_date)); ?>
                                        </div>
                                        <div class="article-categories">
                                            <?php $block_cpt_list->get_taxonomy_categories($post->ID, [
                                                'taxonomy' => $fields_cpt['taxonomy'], 
                                                'divider' => '', 
                                                'separator' => ' | ',
                                                ]) ?>
                                        </div>
                                    </div>
                                    <div class="article-image">
                                        <a href="<?php echo get_permalink($post); ?>">
                                            <?php
                                                $image = get_the_post_thumbnail($post);
                                                if (!empty($image)) {
                                                    echo $image;
                                                } else {
                                                    ?>
                                                    <div class="color"></div>
                                                    <?php
                                                }
                                            ?>
                                        </a>
                                    </div>
                                    <div class="article-summary">
                                        <div class="article-title">
                                            <a href="<?php echo get_permalink($post); ?>">
                                                <?php echo $post->post_title; ?>
                                            </a>
                                        </div>
                                        <div class="article-excerpt">
                                            <?php echo wp_trim_words(wp_strip_all_tags($post->post_content), 11); ?>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    </main>

                    <?php if ($data instanceof WP_Query): ?>
                        <div class="paginate">
                            <?php $rdgb->helpers->rdg_pagination($paged, $num_pages); ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php else: ?>
                <div class="message danger">
                    <span><?php echo __('CPT '.$fields_cpt['cpt'].' does not exist.'); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
