<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_EXPERTS_BANNER;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    // variables
    $expertiImg =  get_field('expert_img');
    $expertCategory =  get_field('expert_category');
    $expertName =  get_field('expert_name');
    $win=  get_field('win');
    $lose =  get_field('lose');
    $push =  get_field('push');
    $gain =  get_field('gain');
    $ad=  get_field('ad');
    $btnLink =  get_field('button_link');
    $btnText =  get_field('button');


    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="left">
                <div class="expert-img">
                    <img src="<?php echo $expertiImg['url']; ?>" alt="<?php echo $expertiImg['alt']; ?>">
                </div>
                <div class="description">
                    <p>EXPERT <span class="expert-category"><?php echo $expertCategory; ?></span></p>
                    <p class="expert-name"><?php echo $expertName; ?></p>
                </div>
            </div>
            <div class="right">
                <div class="odds">
                    <p>WIN <?php echo $win; ?>, LOSE <?php echo $lose; ?>, PUSH <?php echo $push; ?></p>
                    <p class="accent">+ $<?php echo $gain; ?></p>
                </div>
                <div class="sponsor">
                    <?php echo $ad; ?>
                </div>
                
                    <a class="btn" href="<?php echo $btnLink; ?>"><?php echo $btnText; ?></a>
                
            </div>
    </div>
</div>
