<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_POSTS_LIST];
    $block_posts_list = $rdgb->settings->get_block(BLOCK_RDG_POSTS_LIST);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $show = get_field('show');
    $titles = get_field('titles');
    $display = (empty(get_field('display')) || get_field('display') == 'default') ? '' : 'flex';

    $elements = $block_posts_list->get_elements_type(get_fields());
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="body">
            <?php if (is_array($elements) && count($elements) > 0): ?>
                <div class="items <?php echo $display; ?>">
                    <?php foreach($elements as $element): ?>
                        <div class="item">
                            <?php
                                $image = '';
                                if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                    $image = $block_posts_list->get_image($element->ID);
                                } else {
                                    if (isset($element['image']['url']) && !empty($element['image']['url'])) {
                                        $image = $element['image']['url'];
                                    }
                                }
                            ?>
                            
                                <?php
                                    $link_url = '';
                                    $link_target = '_self';
                                    $link_name = 'Read more';
                                    if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                        $link_url = get_permalink($element);
                                    } else {
                                        if (isset($element['link_post']['url']) && !empty($element['link_post']['url'])) {
                                            $link_url = $element['link_post']['url'];
                                        }

                                        if (isset($element['link_post']['target']) && !empty($element['link_post']['target'])) {
                                            $link_target = $element['link_post']['target'];
                                        }

                                        if (isset($element['link_post']['title']) && !empty($element['link_post']['title'])) {
                                            $link_name = $element['link_post']['title'];
                                        }
                                    } 
                                ?>
                                <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                                    <div class="image" style="background-image: url(<?php echo $image; ?>);"></div>
                                </a>
                            
                            <footer>
                                <div class="footer-title">
                                    <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                                        <?php echo (!empty($element->post_title)) ? $element->post_title : $element['title']; ?>
                                    </a>
                                </div>
                                <div class="header">
                                    <div class="date">
                                        <?php
                                            $author_name = get_the_author_meta('display_name', $element->post_author);
                                            $date = (!empty($element->post_date)) ? $element->post_date : $element['date'];

                                            try {
                                                $d = DateTime::createFromFormat('Y-m-d H:i:s', $date);
                                                $date_status = $d && $d->format('Y-m-d H:i:s') == $date;

                                                if ($date_status) {
                                                    $date = $d->format('F j, Y');
                                                }
                                            } catch (\Exception $exception) {
                                                //
                                            }
                                        ?>
                                        <span>By <?php echo $author_name; ?> | <?php echo $date; ?></span>
                                    </div>
                                </div>
                                <?php
                                    $excerpt = '';
                                    if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                        if (!empty($element->post_excerpt)) {
                                            $excerpt = $element->post_excerpt;
                                        } else {
                                            $excerpt = $element->post_content;
                                        }
                                    } else {
                                        if (isset($element['content']) && !empty($element['content'])) {
                                            $excerpt = $element['content'];
                                        }
                                    }
                                ?>
                                <?php if (!empty($excerpt)): ?>
                                    <div class="footer-description">
                                        <?php echo wp_trim_words($excerpt, 35, false); ?>
                                    </div>
                                <?php endif; ?>
                            </footer>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
