<?php  
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_SPORT_INFORMATION;
    $block_classes = [$block_name];

    // Variables
    $blockTitle = get_field('block_title');

    // Handicappers Variables
    $handicappersBlock = get_field('handicappers_block');

    // Picks Variables
    $picksBlock = get_field('picks_block');

    $blockFooter = get_field('block_footer');

    

?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>">
        <div class="si_container">
            <div class="si_header">
                <?php echo $blockTitle; ?>
            </div>
            <div class="si_content">
            <!-- Post Block -->
            <?php if( have_rows('post_block') ): 
                while( have_rows('post_block') ): the_row();
                $showBlock = get_sub_field('show_block');
                $show = get_sub_field('show');
                $manualPost = get_sub_field('manual_post');
                $specificPost = get_sub_field('specific_post');
                $specificLink = get_sub_field('specific_link');
                $latestPost = get_sub_field('latest_post');
                $latestLink = get_sub_field('latest_link');
                ?>
               
                <?php if( $showBlock == 'yes'): ?>
                    <div class="post_block">

                    <?php if ($show == 'latest') {
                        $slug_category = $latestPost;
                        $category = get_category_by_slug($slug_category);
                        
                        if ($category) {
                            $args = array(
                                'cat' => $category->term_id,
                                'posts_per_page' => 1, 
                                'order' => 'DESC', 
                            );
                        
                            $check = new WP_Query($args);

                            if ($check->have_posts()) {
                                while ($check->have_posts()) {
                                    $check->the_post();
                                    if (has_post_thumbnail()) { ?>
                                    <div class="image_wrapper">
                                        <?php the_post_thumbnail('large'); ?>
                                    </div>
                                    <?php } ?>

                                    <p class="title"><?php echo the_title(); ?></p>
                                    <div class="excerpt"><?php echo the_excerpt(); ?></div>
                                    <?php if ($specificLink); { ?>
                                    <a href="<?php echo $latestLink['url']; ?>" target="<?php echo $latestLink['target']; ?>" class="read_more"><?php echo $latestLink['title']; ?></a>
                                    <?php } ?>
                                    <?php }
                                wp_reset_postdata();
                            } else {
                              
                                echo "There isnt post for this category.";
                            }
                        } 
                    } elseif ($show == 'specific') {
                        if ($specificPost) {
                            foreach ($specificPost as $relationship) {
                                // Accede a la información de cada elemento relationship
                                $theTitle = get_the_title($relationship);
                                $excerpt = get_the_excerpt($relationship);
                                $featuredImage = get_the_post_thumbnail( $relationship, 'large'); ?>
                                    <div class="image_wrapper">
                                        <?php echo $featuredImage; ?>
                                    </div>
                                   

                                    <p class="title"><?php echo $theTitle ?></p>
                                    <div class="excerpt"><?php echo $excerpt; ?></div>
                                    
                                <?php }
                        } ?>
                        <?php if ($specificLink); { ?>
                            <a href="<?php echo $specificLink['url']; ?>" target="<?php echo $specificLink['target']; ?>" class="read_more"><?php echo $specificLink['title']; ?></a>
                        <?php } ?>
                    <?php } elseif ($show == 'manual') { ?>
                        <div class="image_wrapper">
                            <img src="<?php echo $manualPost['featured_image']['url']; ?>" alt="<?php echo $manualPost['featured_image']['alt']; ?>" class="featured_image">
                        </div>
                        <p class="title"><?php echo $manualPost['post_title']; ?></p>
                        <p class="excerpt"><?php echo $manualPost['post_excerpt']; ?></p>
                        <a href="<?php echo $manualPost['post_link']['url']; ?>" target="<?php echo $manualPost['post_link']['target']; ?>" class="read_more"><?php echo $manualPost['post_link']['title']; ?></a>
                    <?php } ?>
                    </div>
                <?php endif; ?>
                <?php endwhile; ?>
            <?php endif; ?>
 
            <!-- Previews Block -->
            <?php if( have_rows('previews_block') ): 
                while( have_rows('previews_block') ): the_row();
                $showBlockPreviews = get_sub_field('show_block');
                $previewsTitle = get_sub_field('title');
                $previewsLink = get_sub_field('previews');
                $recapsLink = get_sub_field('recaps');

                ?>
                <?php if( $showBlockPreviews == 'yes'): ?>
                    <div class="previews_block">
                        <p class="title"><?php echo $previewsTitle; ?></p>
                        <div class="previews_list">
                        <?php 
                            if( have_rows('vs_list') ):
                            while( have_rows('vs_list') ) : the_row();

                                $teamA = get_sub_field('team_a');
                                $teamB = get_sub_field('team_b');
                        ?>
                            <div class="list">
                                <div class="first-team-name"><?php echo $teamA; ?></div>
                                <div class="versus">vs.</div>
                                <div class="second-team-name"><?php echo $teamB; ?></div>
                            </div>

                            <?php endwhile;
                        endif; ?>
                        </div>
                        <div class="previews_links">
                            <a href="<?php echo $previewsLink['url']; ?>" target="<?php echo $previewsLink['target']; ?>" class="btn"><?php echo $previewsLink['title'] ?></a>
                            <a href="<?php echo $recapsLink['url']; ?>" target="<?php echo $recapsLink['target']; ?>" class="btn"><?php echo $recapsLink['title'] ?></a>
                        </div>
                    </div>
                <?php endif; ?>
                <?php endwhile; ?>
            <?php endif; ?>

            <!-- Handicappers Block -->
            <?php if( $handicappersBlock ): ?>
                <?php if( $handicappersBlock['show_block'] == 'yes'): ?>
                    <div class="handicappers_block">
                        <p class="title"><?php echo $handicappersBlock['header_title']; ?></p>
                        <div class="handicappers_container">
                            <div class="handicappers_wrapper">
                                <div class="handicappers_avatar">
                                    <img src="<?php echo $handicappersBlock['logo']['url']; ?>" alt="<?php echo $handicappersBlock['logo']['alt']; ?>">
                                </div>
                                <div class="handicappers_info">
                                    <p class="title"><?php echo $handicappersBlock['title']; ?></p>
                                    <p class="sub_title"><?php echo $handicappersBlock['sub_title']; ?></p>
                                    <p class="total">
                                        <?php echo $handicappersBlock['total']; ?>
                                        <span class="picks">
                                            <?php echo $handicappersBlock['picks']; ?>
                                        </span>
                                    </p>
                                </div>
                            </div>
                            <div class="picks_availables">
                                <span><?php echo $handicappersBlock['picks_availables']; ?></span>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <!-- Picks Block -->
            <?php if( have_rows('picks_block') ): 
                while( have_rows('picks_block') ): the_row();
                $showBlockPicks = get_sub_field('show_block');
                $source = get_sub_field('source');
                $picksTitle = get_sub_field('title');
                $picksCategory = get_sub_field('category');
                $picksTime = get_sub_field('time');
                $picksStatus = get_sub_field('status');
                $picksAvailables = get_sub_field('picks_availables');
               
                ?>

                <?php if( $showBlockPicks == 'yes'): ?>
                    <?php if( $source == 'manual') { ?>
                    <div class="picks_block">
                        <p class="title"><?php echo $picksTitle; ?></p>
                        <div class="pick">
                            <div class="picks_header">
                                <div class="sport">
                                    <p><?php echo $picksCategory; ?></p>
                                </div>
                                <div class="date_time">
                                    <p><?php echo $picksTime; ?></p>
                                </div>
                                <div class="status">
                                    <p><?php echo $picksStatus; ?></p>
                                </div>
                            </div>
                            <div class="picks_body">
                                <div class="teams">
                                    <?php 
                                    $teams = 0;
                                        if( have_rows('teams') ):
                                        while( have_rows('teams') ) : the_row();
                                            $class = ($teams == 0) ? 'team_a' : 'team_b';
                                            $teamLogo = get_sub_field('logo');
                                            $teamName = get_sub_field('name');
                                    ?>
                                        <div class="<?php echo $class; ?>">
                                            <img src="<?php echo $teamLogo['url']; ?>" alt="<?php echo $teamLogo['alt']; ?>">
                                            <p><?php echo $teamName; ?></p>
                                        </div>

                                        <?php if ($teams == 0): ?>
                                            <div class="vs_logo">
                                                <span>vs</span>
                                            </div>
                                        <?php endif;?>

                                    <?php   
                                        $teams++;
                                        endwhile;
                                    endif; ?>     
                                </div>
                            </div>
                            <div class="picks_availables">
                                <span><?php echo $picksAvailables; ?></span>
                            </div>
                        </div>
                    </div>
                    <?php }  else {
                        echo "This option is not yet available, please select Manual."; 
                     } ?>
                <?php endif; ?>  
            <?php endwhile; ?>
            <?php endif; ?>
                    </div>
            <div class="si_footer">
                <?php echo $blockFooter; ?>
            </div>
        </div>
    </div>
</div>
