document.addEventListener('change', function(e) {
    const ajax_url = rdg_team_schedules_var.ajaxurl;
    const sport_select_id = document.querySelector('[data-key="rdg_team_schedules_sports"] select').id;
    const leagues_select_id = document.querySelector('[data-key="rdg_team_schedules_leagues"] select').id;
    const select_option = document.querySelector('[data-key="rdg_team_schedules_sports"]').dataset.option;
    
    if (e.target.id == sport_select_id) {
        const sport_value = document.querySelector('[data-key="rdg_team_schedules_sports"] select option:checked').value;

        let seasons = document.querySelector('[data-key="rdg_team_schedules_seasons"] select');
        seasons.innerHTML = '';
        seasons.appendChild(addOptionDefault(select_option));

        let teams = document.querySelector('[data-key="rdg_team_schedules_teams"] select');
        teams.innerHTML = '';
        teams.appendChild(addOptionDefault(select_option));

        if (sport_value == '0') {
            let teams = document.querySelector('[data-key="rdg_team_schedules_leagues"] select');
            teams.innerHTML = '';
            teams.appendChild(addOptionDefault(select_option));

            return;
        }

        fetch(ajax_url, {
            method: "POST",
            headers: {"Content-Type": "application/x-www-form-urlencoded",},
            body: `action=load_leagues&sport=${sport_value}`
        })
        .then(response => response.text())
        .then(resultado => {
            let leagues_array = new Object ;
            leagues_array = JSON.parse(resultado);
            let items = Object.keys(leagues_array).length;
            if (items > 0) {
                let leagues = document.querySelector('[data-key="rdg_team_schedules_leagues"] select');
                leagues.innerHTML = '';

                let seasons = document.querySelector('[data-key="rdg_team_schedules_seasons"] select');
                seasons.innerHTML = '';
                seasons.appendChild(addOptionDefault(select_option));

                let teams = document.querySelector('[data-key="rdg_team_schedules_teams"] select');
                teams.innerHTML = '';
                teams.appendChild(addOptionDefault(select_option));

                for(var k in leagues_array) {
                    var opt = document.createElement('option');
                    opt.value = k;
                    opt.innerHTML = leagues_array[k];
                    leagues.appendChild(opt);
                    }
            }
        })
        .catch(err => console.error(err));
    } else if(e.target.id == leagues_select_id) {
        const leagues_select_val = document.querySelector('[data-key="rdg_team_schedules_leagues"] select option:checked').value;

        if (leagues_select_val == '0') {
            let teams = document.querySelector('[data-key="rdg_team_schedules_teams"] select');
            teams.innerHTML = '';
            teams.appendChild(addOptionDefault(select_option));

            let seasons = document.querySelector('[data-key="rdg_team_schedules_seasons"] select');
            seasons.innerHTML = '';
            seasons.appendChild(addOptionDefault(select_option));

            return;
        }

        fetch(ajax_url, {
            method: "POST",
            headers: {"Content-Type": "application/x-www-form-urlencoded",},
            body: `action=load_teams&league=${leagues_select_val}`
        })
        .then(response => response.text())
        .then(resultado => {
            let teams_array = new Object ;
            teams_array = JSON.parse(resultado);
            let items = Object.keys(teams_array).length;
            if (items > 0) {
                let teams = document.querySelector('[data-key="rdg_team_schedules_teams"] select');
                teams.innerHTML = '';

                for(var k in teams_array) {
                    var opt = document.createElement('option');
                    opt.value = k;
                    opt.innerHTML = teams_array[k];
                    teams.appendChild(opt);
                    }
            }
        })
        .catch(err => console.error(err));

        fetch(ajax_url, {
            method: "POST",
            headers: {"Content-Type": "application/x-www-form-urlencoded",},
            body: `action=load_seasons&league=${leagues_select_val}`
        })
        .then(response => response.text())
        .then(resultado => {
            let seasons_array = new Object ;
            seasons_array = JSON.parse(resultado);
            let items = Object.keys(seasons_array).length;
            if (items > 0) {
                let seasons = document.querySelector('[data-key="rdg_team_schedules_seasons"] select');
                seasons.innerHTML = '';

                for(var k in seasons_array) {
                    var opt = document.createElement('option');
                    opt.value = k;
                    opt.innerHTML = seasons_array[k];
                    seasons.appendChild(opt);
                    }
            }
        })
        .catch(err => console.error(err));
    }
});

function addOptionDefault(select_option) {
    let opt_default = document.createElement('option');
    opt_default.value = 0;
    opt_default.innerHTML = select_option;

    return opt_default;
}

document.addEventListener('click', function(e) {
    const ajax_url = rdg_team_schedules_var.ajaxurl;
    const sport = document.querySelector('#rdg_team_schedule_sport_ajax').value;
    const league = document.querySelector('#rdg_team_schedule_league_ajax').value;
    const team = document.querySelector('#rdg_team_schedule_team_ajax').value;
    const season = document.querySelector('#rdg_team_schedule_season_ajax').value;

    if (e.target.classList.contains("acf-block-preview") || e.target.classList.contains("team-schedule-class")) {
        if (e.target.classList.contains("acf-block-preview") && sport == '') {
            return;
        }
        
        if (e.target.classList.contains("team-schedule-class") && sport == '') {
            return;
        }

        setTimeout(function() {
            if (sport != '') {
                fetch(ajax_url, {
                    method: "POST",
                    headers: {"Content-Type": "application/x-www-form-urlencoded",},
                    body: `action=load_leagues&sport=${sport}`
                })
                .then(response => response.text())
                .then(resultado => {
                    let leagues_array = new Object ;
                    leagues_array = JSON.parse(resultado);
                    let items = Object.keys(leagues_array).length;

                    if (items > 0) {
                        let leagues = document.querySelector('[data-key="rdg_team_schedules_leagues"] select');
                        if (leagues != null) {
                            leagues.innerHTML = '';
                            
                            for(var k in leagues_array) {
                                var opt = document.createElement('option');
                                if (k == league) opt.setAttribute ("selected", true);

                                opt.value = k;
                                opt.innerHTML = leagues_array[k];
                                leagues.appendChild(opt);
                            }
                        }
                        
                    }
                })
                .catch(err => console.error(err));

                if (league != '') {
                    fetch(ajax_url, {
                        method: "POST",
                        headers: {"Content-Type": "application/x-www-form-urlencoded",},
                        body: `action=load_teams&league=${league}`
                    })
                    .then(response => response.text())
                    .then(resultado => {
                        let teams_array = new Object ;
                        teams_array = JSON.parse(resultado);
                        let items = Object.keys(teams_array).length;
    
                        if (items > 0) {
                            let teams = document.querySelector('[data-key="rdg_team_schedules_teams"] select');
                            if (teams != null) {
                                teams.innerHTML = '';
                                
                                for(var k in teams_array) {
                                    var opt = document.createElement('option');
                                    if (k == team) opt.setAttribute ("selected", true);
    
                                    opt.value = k;
                                    opt.innerHTML = teams_array[k];
                                    teams.appendChild(opt);
                                }
                            }
                            
                        }
                    })
                    .catch(err => console.error(err));

                    fetch(ajax_url, {
                        method: "POST",
                        headers: {"Content-Type": "application/x-www-form-urlencoded",},
                        body: `action=load_seasons&league=${league}`
                    })
                    .then(response => response.text())
                    .then(resultado => {
                        let seasons_array = new Object ;
                        seasons_array = JSON.parse(resultado);
                        let items = Object.keys(seasons_array).length;
    
                        if (items > 0) {
                            let seasons = document.querySelector('[data-key="rdg_team_schedules_seasons"] select');
                            if (seasons != null) {
                                seasons.innerHTML = '';
                                
                                for(var k in seasons_array) {
                                    var opt = document.createElement('option');
                                    if (k == season) opt.setAttribute ("selected", true);
    
                                    opt.value = k;
                                    opt.innerHTML = seasons_array[k];
                                    seasons.appendChild(opt);
                                }
                            }
                            
                        }
                    })
                    .catch(err => console.error(err));
                }
            }
        }, 4000);
    }
});
