// Require path.
const path = require('path');

const MiniCssExtractPlugin = require("mini-css-extract-plugin");
const { CleanWebpackPlugin } = require('clean-webpack-plugin');
const ManifestPlugin = require('webpack-manifest-plugin');
const CssMinimizerPlugin = require("css-minimizer-webpack-plugin");

// Configuration object.
const config = {
    // Create the entry points.
    // One for frontend and one for the admin area.
    entry: {
        rdg_main_banner: './blocks/rdg-main-banner/assets/build.js',
        rdg_call_to_action: './blocks/rdg-call-to-action/assets/build.js',
        rdg_title: './blocks/rdg-title/assets/build.js',
        rdg_image_column: './blocks/rdg-image-column/assets/build.js',
        rdg_top_winners: './blocks/rdg-top-winners/assets/build.js',
        rdg_sports_picks: './blocks/rdg-sports-picks/assets/build.js',
        rdg_admin_cappers: './blocks/rdg-admin-cappers/assets/build.js',
        rdg_next_game: './blocks/rdg-next-game/assets/build.js',
        rdg_slider_latest_post: './blocks/rdg-slider-latest-post/assets/build.js',
        rdg_latest_post: './blocks/rdg-latest-post/assets/build.js',
        rdg_picks_list: './blocks/rdg-picks-list/assets/build.js',
        rdg_faq: './blocks/rdg-faq/assets/build.js',
        rdg_faq_script: './blocks/rdg-faq/assets/js/block-faq-script.js',
        rdg_buttons: './blocks/rdg-buttons/assets/build.js',
        rdg_logo_team: './blocks/rdg-logo-team/assets/build.js',
        rdg_odd_betting_select: './blocks/rdg-odd-betting-select/assets/build.js',
        rdg_odd_betting_date: './blocks/rdg-odd-betting-date/assets/build.js',
        rdg_sports_picks_vs: './blocks/rdg-sports-picks-vs/assets/build.js',
        rdg_paragraph_custom: './blocks/rdg-paragraph-custom/assets/build.js',
        rdg_posts_list: './blocks/rdg-posts-list/assets/build.js',
        rdg_new_paragraph_custom: './blocks/rdg-new-paragraph-custom/assets/build.js',
        rdg_picks_vs: './blocks/rdg-picks-vs/assets/build.js',
        rdg_main_promotions: './blocks/rdg-main-promotions/assets/build.js',
        rdg_top_cappers: './blocks/rdg-top-cappers/assets/build.js',
        rdg_favorite_cappers: './blocks/rdg-favorite-cappers/assets/build.js',
        rdg_leader_board: './blocks/rdg-leader-board/assets/build.js',
        rdg_logo_ranking: './blocks/rdg-logo-ranking/assets/build.js',
        rdg_table: './blocks/rdg-table/assets/build.js',
        rdg_admin_cappers_simple: './blocks/rdg-admin-cappers-simple/assets/build.js',
        rdg_table_leagues: './blocks/rdg-table-leagues/assets/build.js',
        rdg_columns_picks: './blocks/rdg-columns-picks/assets/build.js',
        rdg_separator: './blocks/rdg-separator/assets/build.js',
        rdg_single_pick: './blocks/rdg-single-pick/assets/build.js',
        rdg_paragraph_color: './blocks/rdg-paragraph-color/assets/build.js',
        rdg_login: './blocks/rdg-login/assets/build.js',
        rdg_register: './blocks/rdg-register/assets/build.js',
        rdg_box_list: './blocks/rdg-box-list/assets/build.js',
        rdg_socials_icons: './blocks/rdg-socials-icons/assets/build.js',
        rdg_consensus: './blocks/rdg-consensus/assets/build.js',
        rdg_posts_ajax: './blocks/rdg-posts-ajax/assets/build.js',
        rdg_experts_banner: './blocks/rdg-experts-banner/assets/build.js',
        rdg_previews_and_predictions: './blocks/rdg-previews-and-predictions/assets/build.js',
        rdg_secondary_banner: './blocks/rdg-secondary-banner/assets/build.js',
        rdg_buttons_column: './blocks/rdg-buttons-column/assets/build.js',
        rdg_ranking_bookie: './blocks/rdg-ranking-bookie/assets/build.js',
        rdg_bookie_logo: './blocks/rdg-bookie-logo/assets/build.js',
        rdg_product_report: './blocks/rdg-product-report/assets/build.js',
        rdg_best_pph: './blocks/rdg-best-pph/assets/build.js',
        rdg_single_top_handicappers: './blocks/rdg-single-top-handicappers/assets/build.js',
        rdg_simple_post_list: './blocks/rdg-simple-post-list/assets/build.js',
        rdg_heading: './blocks/rdg-heading/assets/build.js',
        rdg_pros_cons: './blocks/rdg-pros-cons/assets/build.js',
        rdg_heading_paragraph: './blocks/rdg-heading-paragraph/assets/build.js',
        rdg_memberships: './blocks/rdg-memberships/assets/build.js',
        rdg_bookie_summary: './blocks/rdg-bookie-summary/assets/build.js',
        rdg_quick_links: './blocks/rdg-quick-links/assets/build.js',
        rdg_bookie_summary_sidebar: './blocks/rdg-bookie-summary-sidebar/assets/build.js',
        rdg_quick_links_sidebar: './blocks/rdg-quick-links-sidebar/assets/build.js',
        rdg_picks_vs_categories: './blocks/rdg-picks-vs-categories/assets/build.js',
        rdg_cpt_list: './blocks/rdg-cpt-list/assets/build.js',
        rdg_best_pph_sites: './blocks/rdg-best-pph-sites/assets/build.js',
        rdg_gambling_center: './blocks/rdg-gambling-center/assets/build.js',
        rdg_bookie_selector: './blocks/rdg-bookie-selector/assets/build.js',
        rdg_banner_sidebar: './blocks/rdg-banner-sidebar/assets/build.js',
        rdg_sport_information: './blocks/rdg-sport-information/assets/build.js',
        rdg_team_schedules: './blocks/rdg-team-schedules/assets/build.js',

        rdg_base_style: './assets/app.js'
    },

    // Create the output files.
    // One for each of our entry points.
    output: {
        // [name] allows for the entry object keys to be used as file names.
        filename: 'js/[name].[contenthash].js',
        // Specify the path to the JS files.
        path: path.resolve( __dirname, 'dist' )
    },
    mode: "development",
    // Setup a loader to transpile down the latest and great JavaScript so older browsers
    // can understand it.
    module: {
        rules: [
            {
                // Look for any .js files.
                test: /\.js$/,
                // Exclude the node_modules folder.
                //exclude: /node_modules/,
                // Use babel loader to transpile the JS files.
                use: [
                    {
                        loader: 'babel-loader',
                        options: {
                            presets: ['@babel/preset-env']
                        },
                    }]
            },
            {
                // Apply rule for .sass, .scss or .css files
                test: /\.(sa|sc|c)ss$/,

                // Set loaders to transform files.
                // Loaders are applying from right to left(!)
                // The first loader will be applied after others
                use: [
                    {
                        // After all CSS loaders we use plugin to do his work.
                        // It gets all transformed CSS and extracts it into separate
                        // single bundled file
                        loader: MiniCssExtractPlugin.loader
                    },
                    {
                        // This loader resolves url() and @imports inside CSS
                        loader: "css-loader",
                    },
                    /*{
                        // Then we apply postCSS fixes like autoprefixer and minifying
                        loader: "postcss-loader"
                    },*/
                    {
                        // First we transform SASS to standard CSS
                        loader: "sass-loader",
                        options: {
                            implementation: require("sass"),
                            sourceMap: true,
                        }
                    }
                ]
            },
            {
                test: /\.(png|jpe?g|gif|svg)$/i,
                use: [
                    {
                        loader: 'file-loader',
                        options: {
                            name: '[name].[ext]',
                            outputPath: 'images/',
                            publicPath: '../images/',
                        }
                    },
                ],
            },
            {
                test: /\.(woff(2)?|ttf|eot)(\?v=\d+\.\d+\.\d+)?$/,
                use: [
                    {
                        loader: 'file-loader',
                        options: {
                            name: '[name].[ext]',
                            outputPath: 'fonts/',
                            publicPath: '../fonts/',
                        }
                    }
                ]
            }
        ]
    },
    optimization: {
        minimizer: [
            // For webpack@5 you can use the `...` syntax to extend existing minimizers (i.e. `terser-webpack-plugin`), uncomment the next line
            // `...`,
            new CssMinimizerPlugin(),
        ],
        minimize: true,
    },
    plugins: [

        new MiniCssExtractPlugin({
            filename: "css/[name].[contenthash].css"
        }),
        new CleanWebpackPlugin(),
        new ManifestPlugin({writeToFileEmit: true}),


    ],
    watchOptions: {
        aggregateTimeout: 300,
        ignored: /node_modules/,
        poll: 1000
    }
}

// Export the config object.
module.exports = config;