<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Faq extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_FAQ;
    private $block_folder_name = 'rdg-faq';
    protected $block_title = 'RDG FAQ';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'faq', 'column'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_faq.css'),
                'enqueue_script' => $rdg_helpers->webpack('rdg_faq_script.js'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_faq_block_zdf45tg54f',
                'title' => 'Block_rdg_faq',
                'fields' => array(
                    array(
                        'key' => 'field_63b8cb3fe6b8b',
                        'label' => 'FAQ Page ID',
                        'name' => 'faq_page_id',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b8c85cb7644',
                        'label' => 'FAQs',
                        'name' => 'faqs',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63b8c876b7645',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'Question?',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63b8c85cb7644',
                            ),
                            array(
                                'key' => 'field_63b8c887b7646',
                                'label' => 'Content',
                                'name' => 'content',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 'Answer',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63b8c85cb7644',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-faq',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function set_json_faqs($items, $faq_page_id) {
        $json_open = "<script type=\"application/ld+json\">\n{\n\t";
        $json_cose = "\n}\n</script>";
    
        $header_open = "\"@context\": \"https://schema.org\",\n\t\"@type\": \"FAQPage\",\n\t\"@name\": \"FAQ\",\n\t\"@id\": \"".$faq_page_id."\",\n\t\"mainEntity\": [\n\t\t";
        $items_json = '';
    
        $i = 1;
        $max = count($items);
    
        foreach($items as $item) {
            $separate = ($max != $i) ? ",\n\t\t" : "\n\t";
            $items_json .= "{\n\t\t\t\"@type\": \"Question\",\n\t\t\t\"name\": \"".$item['title']."\",\n\t\t\t\"acceptedAnswer\": {\n\t\t\t\t\"@type\": \"Answer\",\n\t\t\t\t\"text\": \"".str_replace("\n", '', strip_tags($item['content']))."\"\n\t\t\t}\t\n\t\t}".$separate;
            $i++;
        }
    
        $header_close = "]";
    
        return $json_open.$header_open.$items_json.$header_close.$json_cose;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-faq-question-bg','slug' => 'color-rdg-faq-question-bg','color' => '#f1f1f1'],
            ['name' => 'color-rdg-faq-question-border','slug' => 'color-rdg-faq-question-border','color' => '#0160ac'],
            ['name' => 'color-rdg-faq-question-toggle','slug' => 'color-rdg-faq-question-toggle','color' => '#0160ac'],
            ['name' => 'color-rdg-faq-answer-border','slug' => 'color-rdg-faq-answer-border','color' => '#f1f1f1'],

        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-faq .content .faq-container .question',
                'fontWeight' => '600',
                'fontSize' => '1.125rem',
            ],
        ];
    }
}

$rdg_faq_class = new Rdg_Blocks_Faq();
$rdg_faq_class->init();

return $rdg_faq_class;