<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Picks_List extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PICKS_LIST;
    private $block_folder_name = 'rdg-picks-list';
    protected $block_title = 'RDG Picks List';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'pick', 'list'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;
    protected $config_page_title = '';
    protected $config_menu_title = '';
    protected $config_menu_order = 0;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_picks_list.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_picks_list_block_asd234df3r3g',
                'title' => 'Block_rdg_picks_list',
                'fields' => array(
                    array(
                        'key' => 'field_63e3e81f48bc7',
                        'label' => 'Show as',
                        'name' => 'show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show-full' => 'Full Screen',
                            'show-default' => 'Default',
                        ),
                        'default_value' => 'show-full',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63b5d3f9be33f',
                        'label' => 'Picks',
                        'name' => 'picks',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63b5d3fa0daf5',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63b5d3f9be33f',
                            ),
                            array(
                                'key' => 'field_63b5d3fa115d2',
                                'label' => 'Heading 1',
                                'name' => 'heading_1',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63b5d3f9be33f',
                            ),
                            array(
                                'key' => 'field_63b5d73f777bc',
                                'label' => 'Heading 2',
                                'name' => 'heading_2',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63b5d3f9be33f',
                            ),
                            array(
                                'key' => 'field_63b5db461cd0d',
                                'label' => 'Description',
                                'name' => 'description',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63b5d3f9be33f',
                            ),
                            array(
                                'key' => 'field_63b5d3fa1c88a',
                                'label' => 'List',
                                'name' => 'list',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63b5d3f9be33f',
                            ),
                            array(
                                'key' => 'field_63b5d3fa36989',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63b5d3f9be33f',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_63b5d3f9c1c6a',
                        'label' => 'Buttons',
                        'name' => 'links',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63b5d3fa589d9',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63b5d3f9c1c6a',
                            ),
                            array(
                                'key' => 'field_63b5d3fa589ed',
                                'label' => 'Default Styles',
                                'name' => 'default_styles',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'link-success' => 'Success',
                                    'link-warning' => 'Warning',
                                    'link-danger' => 'Danger',
                                    'link-default' => 'Default',
                                    'custom' => 'Custom',
                                ),
                                'default_value' => 'link-success',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63b5d3f9c1c6a',
                            ),
                            array(
                                'key' => 'field_63b5d3fa5c6a8',
                                'label' => 'Background color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63b5d3fa589ed',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63b5d3f9c1c6a',
                            ),
                            array(
                                'key' => 'field_63b5d3fa6000c',
                                'label' => 'Background Hover Color',
                                'name' => 'background_hover_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63b5d3fa589ed',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63b5d3f9c1c6a',
                            ),
                            array(
                                'key' => 'field_63b5d3fa63cf3',
                                'label' => 'Text color',
                                'name' => 'text_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63b5d3fa589ed',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63b5d3f9c1c6a',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-picks-list',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function getColorsToloadGeneratePress()
    {
        return [
            [
                'name' => 'color-rdg-picks-list-pick-bg',
                'slug' => 'color-rdg-picks-list-pick-bg',
                'color' => '#f1f1f1'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-header-bg',
                'slug' => 'color-rdg-picks-list-pick-header-bg',
                'color' => '#0160ac'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-title',
                'slug' => 'color-rdg-picks-list-pick-title',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-content-heading-1',
                'slug' => 'color-rdg-picks-list-pick-content-heading-1',
                'color' => '#0160ac'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-content-heading-2',
                'slug' => 'color-rdg-picks-list-pick-content-heading-2',
                'color' => '#111111'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-content-list',
                'slug' => 'color-rdg-picks-list-pick-content-list',
                'color' => '#111111'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-content-list-marker',
                'slug' => 'color-rdg-picks-list-pick-content-list-marker',
                'color' => '#0160ac'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-content-link',
                'slug' => 'color-rdg-picks-list-pick-content-link',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-content-link-hover',
                'slug' => 'color-rdg-picks-list-pick-content-link-hover',
                'color' => '#3a96e0'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-content-link-bg',
                'slug' => 'color-rdg-picks-list-pick-content-link-bg',
                'color' => '#0160ac'
            ],
            [
                'name' => 'color-rdg-picks-list-pick-description',
                'slug' => 'color-rdg-picks-list-pick-description',
                'color' => '#111111'
            ],
            [
                'name' => 'color-rdg-picks-pick-header',
                'slug' => 'color-rdg-picks-pick-header',
                'color' => '#ffffff'
            ],
        ];
    }

    public function getStylesToloadGeneratePress()
    {
        return [
            [
                'customSelector' => '.rdg-picks-list .pick .pick-header',
                'fontSize' => '1rem',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.rdg-picks-list .pick .pick-header .title',
                'fontWeight' => '700',
                'lineHeight' => '1.125',
            ],
            [
                'customSelector' => '.rdg-picks-list .pick .pick-content .heading-1',
                'fontSize' => '1.188rem',
                'fontSizeTablet' => '1.125rem',
                'fontSizeMobile' => '0.938rem',
                'fontWeight' => '600',
                'lineHeight' => '0.8',
                'lineHeightMobile' => '1'
            ],
            [
                'customSelector' => '.rdg-picks-list .pick .pick-content .heading-2',
                'fontSize' => '2rem',
                'fontSizeTablet' => '1.938rem',
                'fontSizeMobile' => '1.563rem',
                'fontWeight' => '900',
                'lineHeight' => '1.3',
                'lineHeightMobile' => '1.1',
            ],
            [
                'customSelector' => '.rdg-picks-list .pick .description',
                'fontSize' => '1rem',
                'lineHeight' => '1.5',
            ],
            [
                'customSelector' => '.rdg-picks-list .pick .pick-list',
                'fontSize' => '1.063rem',
                'fontWeight' => '600',
                'fontStyle' => 'italic',
            ],
            [
                'customSelector' => '.rdg-picks-list .pick .pick-list ul li::marker',
                'fontSize' => '1.063rem'
            ],
            [
                'customSelector' => '.rdg-picks-list .pick .pick-link a',
                'fontSize' => '1.188rem',
                'fontSizeMobile' => '1rem',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.rdg-picks-list .buttons a',
                'fontSize' => '1rem',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.separate-containers .inside-right-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-content .heading-1',
                'fontSize' => '.813rem',
                'fontWeight' => '600',
                'lineHeight' => '1.2',
            ],
            [
                'customSelector' => '.separate-containers .inside-left-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-content .heading-1',
                'fontSize' => '.813rem',
                'fontWeight' => '600',
                'lineHeight' => '1.2',
            ],
            [
                'customSelector' => '.separate-containers .inside-right-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-content .heading-2',
                'fontSize' => '1.25rem',
                'fontSizeTablet' => '1.188rem',
                'fontSizeMobile' => '1.188rem',
                'fontWeight' => '900',
                'lineHeight' => '1.2',
            ],
            [
                'customSelector' => '.separate-containers .inside-left-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-content .heading-2',
                'fontSize' => '1.25rem',
                'fontSizeTablet' => '1.188rem',
                'fontSizeMobile' => '1.188rem',
                'fontWeight' => '900',
                'lineHeight' => '1.2',
            ],
            [
                'customSelector' => '.separate-containers .inside-right-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-description',
                'fontSize' => '.75rem',
                'fontSizeTablet' => '.688rem',
                'fontSizeMobile' => '.813rem'
            ],
            [
                'customSelector' => '.separate-containers .inside-left-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-description',
                'fontSize' => '.75rem',
                'fontSizeTablet' => '.688rem',
                'fontSizeMobile' => '.813rem'
            ],
            [
                'customSelector' => '.separate-containers .inside-right-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-list',
                'fontSize' => '.75rem',
                'fontSizeTablet' => '.688rem',
                'fontSizeMobile' => '.875rem',
                'fontWeight' => '700',
                'lineHeight' => '1.2',
            ],
            [
                'customSelector' => '.separate-containers .inside-left-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-list',
                'fontSize' => '.75rem',
                'fontSizeTablet' => '.688rem',
                'fontSizeMobile' => '.875rem',
                'fontWeight' => '700',
                'lineHeight' => '1.2',
            ],
            [
                'customSelector' => '.separate-containers .inside-right-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-link a',
                'fontSize' => '1rem',
                'fontSizeTablet' => '.813rem',
                'fontSizeMobile' => '1rem',
            ],
            [
                'customSelector' => '.separate-containers .inside-left-sidebar .rdg-picks-list .container.content .picks .pick .content .pick-link a',
                'fontSize' => '1rem',
                'fontSizeTablet' => '.813rem',
                'fontSizeMobile' => '1rem',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-picks-list a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_picks_list_class = new Rdg_Blocks_Picks_List();
$rdg_picks_list_class->init();

return $rdg_picks_list_class;
