<?php
global $rdgb;

$key = 'promo_sites_position';
$lastPosition = false;
if ($rdgb->helpers->init_redis()) {
    $lastPosition = $rdgb->helpers->get_redis($key);
}

$promo_sites = get_field('promo_sites', 'options');

if ($promo_sites) {
    if ($lastPosition !== false && $lastPosition < count($promo_sites) - 1) {
        $nextPosition = $lastPosition + 1;
    } else {
        $nextPosition = 0;
    }

    $selected_site = $promo_sites[$nextPosition];    
    $rdgb->helpers->set_redis($key, $nextPosition);

    $logo = $selected_site['promote_site_logo'];
    $site_name = $selected_site['promote_site_name'];
    $offer_amount = $selected_site['promote_site_offer_amount'];
    $offer_description = $selected_site['promote_site_offer_description'];
    $actionLink = $selected_site['promote_action'];
    $termsLink = $selected_site['terms_and_conditions'];
    $offer_features = $selected_site['promote_site_offer_features'];

?>
<div class="rdg-blocks">
    <div class="rdg-blocks-promote">
        <div class="header">
            <div class="promote-left">
            <?php if ($logo): ?>
                    <img class="promote-logo" src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_attr($logo['alt']); ?>" />
                <?php endif; ?>
                <?php if ($site_name): ?>
                    <div class="promote-name"><?php echo esc_html($site_name); ?></div>
                <?php endif; ?>
            </div>
            <div class="promote-right">
                <?php if ($offer_amount): ?>            
                    <span class="promote-offer-amount">$<?php echo esc_html($offer_amount); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <div class="body">
            <div class="promote-content">
                <?php if ($offer_description): ?>
                    <p class="promote-offer-description"><?php echo nl2br(esc_html($offer_description)); ?></p>
                <?php endif; ?>

                <?php if ($actionLink): 
                        $link_target = $actionLink['target'] ? $actionLink['target'] : '_self';
                    ?>
                    <div class="promote-action-button">
                        <a href="<?php echo esc_url( $actionLink['url'] ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $actionLink['title'] ); ?></a>
                    </div>
                <?php endif; ?> 
            </div>
        </div>
        <?php if (!empty($offer_features) && is_array($offer_features)): ?>
            <ul class="promote-features">
                <?php foreach ($offer_features as $feature): ?>
                    <li><?php echo esc_html($feature['promote_site_feature']); ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
        <?php if ($termsLink): 
                $terms_target = $termsLink['target'] ? $termsLink['target'] : '_self';
            ?>
            <div class="footer">
                <a class="terms-link" href="<?php echo esc_url( $termsLink['url'] ); ?>" target="<?php echo esc_attr( $terms_target ); ?>"><?php echo esc_html( $termsLink['title'] ); ?></a>
            </div>
        <?php endif; ?>
</div>

<?php
} 
?>