<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = ['rdg-logo-team'];
    $block_logo_team = $rdgb->settings->get_block(BLOCK_RDG_LOGO_TEAM);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $link = get_field('link');
    $title = get_field('title');
    $description = get_field('text');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $image = (!empty(get_field('image'))) ? get_field('image') : null;
    $padding_column = (!empty(get_field('padding_column'))) ? get_field('padding_column') : 0;
    [$width_image, $width_items] = $block_logo_team->get_width(!empty($image), [$title, $description]);
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div class="content" style="--padding-column: <?php echo $padding_column.'rem';?>;">
                <?php if (!empty($image)): ?>
                    <div class="image <?php echo $width_image; ?>">
                        <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    </div>
                <?php endif; ?>
                <div class="items <?php echo $width_items; ?>">
                    <div class="item">
                        <?php if (!empty($link['url']) && !empty($link['title'])): ?>
                            <a class="item-link" href="<?php echo $link['url']; ?>" target="<?php echo (!empty($link['target'])) ? $link['target'] : '_self'; ?>"><?php echo $link['title']; ?></a>
                        <?php endif; ?>

                        <?php if (!empty($title)): ?>
                            <span class="item-title"><?php echo $title; ?></span>
                        <?php endif; ?>
                        <?php if (!empty($description)): ?>
                            <p class="item-text"><?php echo $description; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
