<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Sport_Information extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_SPORT_INFORMATION;
    private $block_folder_name = 'rdg-sport-information';
    protected $block_title = 'RDG Sport Information';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'banner', 'secondary', 'secondary banner'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $config_page_title = 'RDG Sport Information';
    protected $config_menu_title = 'Sport Information';
    protected $config_menu_order = 18;


    public function init() {
        $this->register_block();
        $this->register_fields();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_sport_information.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        $rdg_helpers = new Rdg_Blocks_Helpers();

        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group( array(
                'key' => 'group_6584edc20d05f',
                'title' => 'RDG Sport Information',
                'fields' => array(
                    array(
                        'key' => 'field_6585096df9941',
                        'label' => 'Header Title',
                        'name' => 'header_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6584f66f01dd6',
                        'label' => 'Post Block',
                        'name' => 'post_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6584f69401dd7',
                                'label' => 'Show block?',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => 'yes',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_65de5b9bbf21c',
                                'label' => 'Content Source',
                                'name' => 'content_source',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'manual' => 'Manual',
                                    'specific' => 'Specific Post',
                                    'latest' => 'Latest Post',
                                ),
                                'default_value' => 'manual',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                            array(
                                'key' => 'field_6584f6ae01dd8',
                                'label' => 'Featured Image',
                                'name' => 'featured_image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                            ),
                            array(
                                'key' => 'field_6584f6c701dd9',
                                'label' => 'Post Title',
                                'name' => 'post_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6584f6dd01dda',
                                'label' => 'Post Excerpt',
                                'name' => 'post_excerpt',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                            ),
                            array(
                                'key' => 'field_6584f6e601ddb',
                                'label' => 'Post Link',
                                'name' => 'post_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_65677e15dc3ed',
                                'label' => 'Specific Post',
                                'name' => 'specific_post',
                                'aria-label' => '',
                                'type' => 'relationship',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'specific',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'post_type' => array(
                                    0 => 'post',
                                ),
                                'post_status' => array(
                                    0 => 'publish',
                                ),
                                'taxonomy' => '',
                                'filters' => array(
                                    0 => 'search',
                                    1 => 'taxonomy',
                                ),
                                'return_format' => 'object',
                                'min' => 1,
                                'max' => 1,
                                'elements' => '',
                            ),
                            array(
                                'key' => 'field_656f2d3405a2c',
                                'label' => 'Specific Link',
                                'name' => 'specific_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'specific',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_656c848df397a',
                                'label' => 'Latest Post',
                                'name' => 'latest_post',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'latest',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'alabama-crimson-tide' => '- Alabama Crimson Tide',
                                    'american-league' => '- American League',
                                    'anaheim-ducks' => '- Anaheim Ducks',
                                    'arizona-cardinals' => '- Arizona Cardinals',
                                    'arizona-coyotes' => '- Arizona Coyotes',
                                    'arizona-diamondbacks' => '- Arizona Diamondbacks',
                                    'arizona-wildcats' => '- Arizona Wildcats',
                                    'arkansas-razorbacks' => '- Arkansas Razorbacks',
                                    'arkansas-st-red-wolves' => '- Arkansas St. Red Wolves',
                                    'atlanta-braves' => '- Atlanta Braves',
                                    'atlanta-dream' => '- Atlanta Dream',
                                    'atlanta-falcons' => '- Atlanta Falcons',
                                    'atlanta-faze' => '- Atlanta FaZe',
                                    'atlanta-hawks' => '- Atlanta Hawks',
                                    'atlanta-reign' => '- Atlanta Reign',
                                    'atlanta-united-fc' => '- Atlanta United FC',
                                    'auburn-tigers' => '- Auburn Tigers',
                                    'austin-fc' => '- Austin FC',
                                    'auto-racing' => 'Auto Racing',
                                    'baltimore-orioles' => '- Baltimore Orioles',
                                    'baltimore-ravens' => '- Baltimore Ravens',
                                    'baseball' => 'Baseball',
                                    'basketball' => 'Basketball',
                                    'baylor-bears' => '- Baylor Bears',
                                    'boston-bruins' => '- Boston Bruins',
                                    'boston-celtics' => '- Boston Celtics',
                                    'boston-red-sox' => '- Boston Red Sox',
                                    'boston-uprising' => '- Boston Uprising',
                                    'brooklyn-nets' => '- Brooklyn Nets',
                                    'buffalo-bills' => '- Buffalo Bills',
                                    'buffalo-sabres' => '- Buffalo Sabres',
                                    'calgary-flames' => '- Calgary Flames',
                                    'callofduty' => '- CALLOFDUTY',
                                    'carolina-hurricanes' => '- Carolina Hurricanes',
                                    'carolina-panthers' => '- Carolina Panthers',
                                    'cf-montreal' => '- CF Montreal',
                                    'champ' => '- CHAMP',
                                    'charlotte-fc' => '- Charlotte FC',
                                    'charlotte-hornets' => '- Charlotte Hornets',
                                    'chengdu-hunters' => '- Chengdu Hunters',
                                    'chicago-bears' => '- Chicago Bears',
                                    'chicago-blackhawks' => '- Chicago Blackhawks',
                                    'chicago-bulls' => '- Chicago Bulls',
                                    'chicago-cubs' => '- Chicago Cubs',
                                    'chicago-fire' => '- Chicago Fire',
                                    'chicago-sky' => '- Chicago Sky',
                                    'chicago-white-sox' => '- Chicago White Sox',
                                    'cincinnati-bengals' => '- Cincinnati Bengals',
                                    'cincinnati-reds' => '- Cincinnati Reds',
                                    'clemson-tigers' => '- Clemson Tigers',
                                    'cleveland-browns' => '- Cleveland Browns',
                                    'cleveland-cavaliers' => '- Cleveland Cavaliers',
                                    'cleveland-guardians' => '- Cleveland Guardians',
                                    'colorado-avalanche' => '- Colorado Avalanche',
                                    'colorado-rapids' => '- Colorado Rapids',
                                    'colorado-rockies' => '- Colorado Rockies',
                                    'columbus-blue-jackets' => '- Columbus Blue Jackets',
                                    'columbus-crew-sc' => '- Columbus Crew SC',
                                    'concacaf' => '- CONCACAF',
                                    'connecticut-huskies' => '- Connecticut Huskies',
                                    'connecticut-sun' => '- Connecticut Sun',
                                    'creighton-bluejays' => '- Creighton Bluejays',
                                    'csgo' => '- CSGO',
                                    'd-c-united' => '- D.C. United',
                                    'dallas-cowboys' => '- Dallas Cowboys',
                                    'dallas-fuel' => '- Dallas Fuel',
                                    'dallas-mavericks' => '- Dallas Mavericks',
                                    'dallas-stars' => '- Dallas Stars',
                                    'dallas-wings' => '- Dallas Wings',
                                    'denver-broncos' => '- Denver Broncos',
                                    'denver-nuggets' => '- Denver Nuggets',
                                    'depaul-blue-demons' => '- DePaul Blue Demons',
                                    'detroit-lions' => '- Detroit Lions',
                                    'detroit-pistons' => '- Detroit Pistons',
                                    'detroit-red-wings' => '- Detroit Red Wings',
                                    'detroit-tigers' => '- Detroit Tigers',
                                    'dota' => '- DOTA',
                                    'drexel-dragons' => '- Drexel Dragons',
                                    'edmonton-oilers' => '- Edmonton Oilers',
                                    'esports' => 'eSports',
                                    'fc-cincinnati' => '- FC Cincinnati',
                                    'fc-dallas' => '- FC Dallas',
                                    'fighting' => 'Fighting',
                                    'florida-mayhem' => '- Florida Mayhem',
                                    'florida-mutineers' => '- Florida Mutineers',
                                    'florida-panthers' => '- Florida Panthers',
                                    'florida-state-seminoles' => '- Florida State Seminoles',
                                    'football' => 'Football',
                                    'george-washington-colonials' => '- George Washington Colonials',
                                    'georgetown-hoyas' => '- Georgetown Hoyas',
                                    'georgia-bulldogs' => '- Georgia Bulldogs',
                                    'golden-state-warriors' => '- Golden State Warriors',
                                    'golf' => 'Golf',
                                    'gonzaga-bulldogs' => '- Gonzaga Bulldogs',
                                    'green-bay-packers' => '- Green Bay Packers',
                                    'guangzhou-charge' => '- Guangzhou Charge',
                                    'hangzhou-spark' => '- Hangzhou Spark',
                                    'hockey' => 'Hockey',
                                    'houston-astros' => '- Houston Astros',
                                    'houston-cougars' => '- Houston Cougars',
                                    'houston-dash' => '- Houston Dash',
                                    'houston-dynamo' => '- Houston Dynamo',
                                    'houston-outlaws' => '- Houston Outlaws',
                                    'houston-rockets' => '- Houston Rockets',
                                    'houston-texans' => '- Houston Texans',
                                    'indiana-fever' => '- Indiana Fever',
                                    'indiana-hoosiers' => '- Indiana Hoosiers',
                                    'indiana-pacers' => '- Indiana Pacers',
                                    'indianapolis-colts' => '- Indianapolis Colts',
                                    'indy' => '- INDY',
                                    'inter-miami-cf' => '- Inter Miami CF',
                                    'iowa-hawkeyes' => '- Iowa Hawkeyes',
                                    'jacksonville-jaguars' => '- Jacksonville Jaguars',
                                    'kansas-city' => '- Kansas City',
                                    'kansas-city-chiefs' => '- Kansas City Chiefs',
                                    'kansas-city-royals' => '- Kansas City Royals',
                                    'kansas-jayhawks' => '- Kansas Jayhawks',
                                    'kentucky-wildcats' => '- Kentucky Wildcats',
                                    'las-vegas-aces' => '- Las Vegas Aces',
                                    'las-vegas-raiders' => '- Las Vegas Raiders',
                                    'london-royal-ravens' => '- London Royal Ravens',
                                    'los-angeles-angels' => '- Los Angeles Angels',
                                    'los-angeles-chargers' => '- Los Angeles Chargers',
                                    'los-angeles-clippers' => '- Los Angeles Clippers',
                                    'los-angeles-dodgers' => '- Los Angeles Dodgers',
                                    'los-angeles-fc' => '- Los Angeles FC',
                                    'los-angeles-galaxy' => '- Los Angeles Galaxy',
                                    'los-angeles-kings' => '- Los Angeles Kings',
                                    'los-angeles-lakers' => '- Los Angeles Lakers',
                                    'los-angeles-rams' => '- Los Angeles Rams',
                                    'los-angeles-sparks' => '- Los Angeles Sparks',
                                    'los-angeles-thieves' => '- Los Angeles Thieves',
                                    'louisiana-state-tigers' => '- Louisiana State Tigers',
                                    'marquette-golden-eagles' => '- Marquette Golden Eagles',
                                    'massachusetts-lowell-river-hawks' => '- Massachusetts Lowell River Hawks',
                                    'mcneese-st-mcneese' => '- McNeese St. McNeese',
                                    'memphis-grizzlies' => '- Memphis Grizzlies',
                                    'memphis-tigers' => '- Memphis Tigers',
                                    'miami-dolphins' => '- Miami Dolphins',
                                    'miami-heat' => '- Miami Heat',
                                    'miami-marlins' => '- Miami Marlins',
                                    'miami-florida-hurricanes' => '- Miami-Florida Hurricanes',
                                    'michigan-wolverines' => '- Michigan Wolverines',
                                    'milwaukee-brewers' => '- Milwaukee Brewers',
                                    'milwaukee-bucks' => '- Milwaukee Bucks',
                                    'minnesota-lynx' => '- Minnesota Lynx',
                                    'minnesota-timberwolves' => '- Minnesota Timberwolves',
                                    'minnesota-twins' => '- Minnesota Twins',
                                    'minnesota-united-fc' => '- Minnesota United FC',
                                    'minnesota-vikings' => '- Minnesota Vikings',
                                    'minnesota-wild' => '- Minnesota Wild',
                                    'mississippi-rebels' => '- Mississippi Rebels',
                                    'mississippi-state-bulldogs' => '- Mississippi State Bulldogs',
                                    'mlb' => '- MLB',
                                    'mls' => '- MLS',
                                    'montreal-canadiens' => '- Montreal Canadiens',
                                    'nas' => '- NAS',
                                    'nashville-predators' => '- Nashville Predators',
                                    'nashville-sc' => '- Nashville SC',
                                    'national-league' => '- National League',
                                    'nba' => '- NBA',
                                    'nba2k' => '- NBA2K',
                                    'nc-state-wolfpack' => '- NC State Wolfpack',
                                    'ncaab' => '- NCAAB',
                                    'new-england-patriots' => '- New England Patriots',
                                    'new-england-revolution' => '- New England Revolution',
                                    'new-jersey-devils' => '- New Jersey Devils',
                                    'new-mexico-lobos' => '- New Mexico Lobos',
                                    'new-mexico-st-aggies' => '- New Mexico St. Aggies',
                                    'new-orleans-pelicans' => '- New Orleans Pelicans',
                                    'new-orleans-saints' => '- New Orleans Saints',
                                    'new-york-city-fc' => '- New York City FC',
                                    'new-york-excelsior' => '- New York Excelsior',
                                    'new-york-giants' => '- New York Giants',
                                    'new-york-islanders' => '- New York Islanders',
                                    'new-york-jets' => '- New York Jets',
                                    'new-york-knicks' => '- New York Knicks',
                                    'new-york-liberty' => '- New York Liberty',
                                    'new-york-mets' => '- New York Mets',
                                    'new-york-rangers' => '- New York Rangers',
                                    'new-york-red-bulls' => '- New York Red Bulls',
                                    'new-york-subliners' => '- New York Subliners',
                                    'new-york-yankees' => '- New York Yankees',
                                    'nfl' => '- NFL',
                                    'nhl' => '- NHL',
                                    'niagara-purple-eagles' => '- Niagara Purple Eagles',
                                    'north-carolina-courage' => '- North Carolina Courage',
                                    'north-carolina-tar-heels' => '- North Carolina Tar Heels',
                                    'northwestern-wildcats' => '- Northwestern Wildcats',
                                    'nwsl' => '- NWSL',
                                    'oakland-athletics' => '- Oakland Athletics',
                                    'oklahoma-city-thunder' => '- Oklahoma City Thunder',
                                    'ol-reign' => '- OL Reign',
                                    'optic-texas' => '- OpTic Texas',
                                    'oregon-ducks' => '- Oregon Ducks',
                                    'orlando-city-sc' => '- Orlando City SC',
                                    'orlando-magic' => '- Orlando Magic',
                                    'ottawa-senators' => '- Ottawa Senators',
                                    'overwatch' => '- OVERWATCH',
                                    'pennsylvania-quakers' => '- Pennsylvania Quakers',
                                    'pga' => '- PGA',
                                    'philadelphia-76ers' => '- Philadelphia 76ers',
                                    'philadelphia-eagles' => '- Philadelphia Eagles',
                                    'philadelphia-flyers' => '- Philadelphia Flyers',
                                    'philadelphia-phillies' => '- Philadelphia Phillies',
                                    'philadelphia-union' => '- Philadelphia Union',
                                    'phoenix-mercury' => '- Phoenix Mercury',
                                    'phoenix-suns' => '- Phoenix Suns',
                                    'pittsburgh-penguins' => '- Pittsburgh Penguins',
                                    'pittsburgh-pirates' => '- Pittsburgh Pirates',
                                    'pittsburgh-steelers' => '- Pittsburgh Steelers',
                                    'portland-timbers' => '- Portland Timbers',
                                    'portland-trail-blazers' => '- Portland Trail Blazers',
                                    'purdue-boilermakers' => '- Purdue Boilermakers',
                                    'racing-louisville-fc' => '- Racing Louisville FC',
                                    'real-salt-lake' => '- Real Salt Lake',
                                    'rutgers-scarlet-knights' => '- Rutgers Scarlet Knights',
                                    'sacramento-kings' => '- Sacramento Kings',
                                    'san-antonio-spurs' => '- San Antonio Spurs',
                                    'san-diego' => '- San Diego',
                                    'san-diego-padres' => '- San Diego Padres',
                                    'san-diego-st-aztecs' => '- San Diego St. Aztecs',
                                    'san-francisco-49ers' => '- San Francisco 49ers',
                                    'san-francisco-giants' => '- San Francisco Giants',
                                    'san-francisco-shock' => '- San Francisco Shock',
                                    'san-jose-earthquakes' => '- San Jose Earthquakes',
                                    'san-jose-sharks' => '- San Jose Sharks',
                                    'seattle-kraken' => '- Seattle Kraken',
                                    'seattle-mariners' => '- Seattle Mariners',
                                    'seattle-seahawks' => '- Seattle Seahawks',
                                    'seattle-sounders-fc' => '- Seattle Sounders FC',
                                    'seattle-storm' => '- Seattle Storm',
                                    'seoul-infernal' => '- Seoul Infernal',
                                    'seton-hall-pirates' => '- Seton Hall Pirates',
                                    'soccer' => 'Soccer',
                                    'southern-california-trojans' => '- Southern California Trojans',
                                    'southern-miss-golden-eagles' => '- Southern Miss Golden Eagles',
                                    'sporting-kansas-city' => '- Sporting Kansas City',
                                    'sports' => 'Sports',
                                    'st-johns-red-storm' => '- St. John\'s Red Storm',
                                    'st-louis-blues' => '- St. Louis Blues',
                                    'st-louis-cardinals' => '- St. Louis Cardinals',
                                    'st-louis-city-sc' => '- St. Louis City SC',
                                    'syracuse-orange' => '- Syracuse Orange',
                                    'tampa-bay-buccaneers' => '- Tampa Bay Buccaneers',
                                    'tampa-bay-lightning' => '- Tampa Bay Lightning',
                                    'tampa-bay-rays' => '- Tampa Bay Rays',
                                    'tennessee-titans' => '- Tennessee Titans',
                                    'tennessee-volunteers' => '- Tennessee Volunteers',
                                    'texas-longhorns' => '- Texas Longhorns',
                                    'texas-rangers' => '- Texas Rangers',
                                    'texas-tech-red-raiders' => '- Texas Tech Red Raiders',
                                    'toronto-blue-jays' => '- Toronto Blue Jays',
                                    'toronto-defiant' => '- Toronto Defiant',
                                    'toronto-fc' => '- Toronto FC',
                                    'toronto-maple-leafs' => '- Toronto Maple Leafs',
                                    'toronto-raptors' => '- Toronto Raptors',
                                    'truck' => '- TRUCK',
                                    'uc-riverside-highlanders' => '- UC Riverside Highlanders',
                                    'ucla-bruins' => '- UCLA Bruins',
                                    'ufc' => '- UFC',
                                    'usa' => '- USA',
                                    'utah-jazz' => '- Utah Jazz',
                                    'vancouver-canucks' => '- Vancouver Canucks',
                                    'vancouver-whitecaps-fc' => '- Vancouver Whitecaps FC',
                                    'vanderbilt-commodores' => '- Vanderbilt Commodores',
                                    'vegas-golden-knights' => '- Vegas Golden Knights',
                                    'washington-capitals' => '- Washington Capitals',
                                    'washington-commanders' => '- Washington Commanders',
                                    'washington-huskies' => '- Washington Huskies',
                                    'washington-justice' => '- Washington Justice',
                                    'washington-mystics' => '- Washington Mystics',
                                    'washington-nationals' => '- Washington Nationals',
                                    'washington-spirit' => '- Washington Spirit',
                                    'washington-st-cougars' => '- Washington St. Cougars',
                                    'washington-wizards' => '- Washington Wizards',
                                    'west-virginia-mountaineers' => '- West Virginia Mountaineers',
                                    'winnipeg-jets' => '- Winnipeg Jets',
                                    'wnba' => '- WNBA',
                                    'xavier-musketeers' => '- Xavier Musketeers',
                                ),
                                'default_value' => 'NHL',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                            array(
                                'key' => 'field_656f2d1b1af9b',
                                'label' => 'Latest Link',
                                'name' => 'latest_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f69401dd7',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                        array(
                                            'field' => 'field_65de5b9bbf21c',
                                            'operator' => '==',
                                            'value' => 'latest',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6584f7714d10f',
                        'label' => 'Previews Block',
                        'name' => 'previews_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6584f7864d110',
                                'label' => 'Show Block?',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => 'yes',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_6584fcbe5ed6f',
                                'label' => 'Block Title',
                                'name' => 'block_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7864d110',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6584fcd45ed70',
                                'label' => 'Vs List',
                                'name' => 'vs_list',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7864d110',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'pagination' => 0,
                                'min' => 1,
                                'max' => 3,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6584fcee5ed71',
                                        'label' => 'Team A',
                                        'name' => 'team_a',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6584fcd45ed70',
                                    ),
                                    array(
                                        'key' => 'field_6584fcf35ed72',
                                        'label' => 'Team B',
                                        'name' => 'team_b',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6584fcd45ed70',
                                    ),
                                ),
                            ),
                            array(
                                'key' => 'field_6584fd155ed73',
                                'label' => 'Previews Link',
                                'name' => 'previews_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7864d110',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_6584fd265ed74',
                                'label' => 'Recaps Link',
                                'name' => 'recaps_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7864d110',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6584f7bc4d111',
                        'label' => 'Handicappers Block',
                        'name' => 'handicappers_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6584f7bc4d112',
                                'label' => 'Show Block?',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => 'yes',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_6584fbc144059',
                                'label' => 'Block Title',
                                'name' => 'block_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7bc4d112',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6584fbd84405a',
                                'label' => 'Handicapper Logo',
                                'name' => 'handicapper_logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7bc4d112',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                            ),
                            array(
                                'key' => 'field_6584fbf14405b',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7bc4d112',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6584fc184405c',
                                'label' => 'Subtitle',
                                'name' => 'subtitle',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7bc4d112',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6584fc244405d',
                                'label' => 'Total',
                                'name' => 'total',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7bc4d112',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6584fc384405e',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7bc4d112',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6584fc484405f',
                                'label' => 'Picks Availables',
                                'name' => 'picks_availables',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6584f7bc4d112',
                                            'operator' => '==',
                                            'value' => 'yes',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_65674ed90ad74',
                        'label' => 'Picks Block',
                        'name' => 'picks_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_65674ed90ad75',
                                'label' => 'Show Block',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => 'yes',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_656e113153afc',
                                'label' => 'Source',
                                'name' => 'source',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'api' => 'API',
                                    'manual' => 'Manual',
                                ),
                                'default_value' => 'manual',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_656f739292cf5',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656c848df689c',
                                'label' => 'Picks Sport',
                                'name' => 'picks_sport',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'api',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $rdg_helpers->get_sporst_parts_options(true),
                                'default_value' => '',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 1,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                            array(
                                'key' => 'field_656e115753afd',
                                'label' => 'Category',
                                'name' => 'category',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656e28c86a1a0',
                                'label' => 'Time',
                                'name' => 'time',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'YYYY-MM-DD HH:MM',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656e28d26a1a1',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656e29336a1a3',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 2,
                                'max' => 2,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_656e294f6a1a4',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_656e29336a1a3',
                                    ),
                                    array(
                                        'key' => 'field_656e29636a1a5',
                                        'label' => 'Name',
                                        'name' => 'name',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_656e29336a1a3',
                                    ),
                                ),
                            ),
                            array(
                                'key' => 'field_656e290f6a1a2',
                                'label' => 'Picks Availables',
                                'name' => 'picks_availables',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6585097bf9942',
                        'label' => 'Footer Title',
                        'name' => 'footer_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-sport-information',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
        endif;                    
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group( array(
                'key' => 'group_65ddf2c5236a6',
                'title' => 'API Pick Vs',
                'fields' => array(
                    array(
                        'key' => 'field_65ddf2c52e172',
                        'label' => 'Pick Vs API URL',
                        'name' => 'pick_vs_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_65ddf2c531e24',
                        'label' => 'Pick Vs API Token',
                        'name' => 'pick_vs_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_65ddf2c535d26',
                        'label' => 'Pick Vs Cache Refresh',
                        'name' => 'pick_vs_cache_refresh',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sport-information',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ) );
            
                acf_add_local_field_group( array(
                'key' => 'group_65ddee9ca48c1',
                'title' => 'API Top Handicappers',
                'fields' => array(
                    array(
                        'key' => 'field_65ddee9db3aaf',
                        'label' => 'Top Handicappers API URL',
                        'name' => 'top_handicappers_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_65ddeebcb3ab0',
                        'label' => 'Top Handicappers API Token',
                        'name' => 'top_handicappers_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_65ddeec6b3ab1',
                        'label' => 'Top Handicappers Cache Refresh',
                        'name' => 'top_handicappers_cache_refresh',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sport-information',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ) );

        endif;
    }

    public function get_api_attributes($items = null, $attributes = []) {
        $api_url = get_field('pick_vs_api_url', 'option');
        $api_token = get_field('pick_vs_api_token', 'option');
        $cache_refresh = get_field('pick_vs_cache_refresh', 'option');
        $items = "1";

        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;
        $api_url .= '?gamesToShow='.$items;
        // $api_url .= '&sport=2';

        if (isset($attributes['sports_parts']) && strpos($attributes['sports_parts'], '-')) {
            list($sport, $game_part) = explode('-', $attributes['sports_parts']);
        } else {
            $game_part = null;

            if (isset($attributes['sports_parts']) && !empty($attributes['sports_parts'])) {
                $sport = $attributes['sports_parts'];
            } else {
                $sport = null;
            }
        }

        if (!empty($sport)) {
            $api_url .= '&sport='.$sport;
        }

       
        $api_request = $api_url.'&api_token='.$api_token;
        
        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
        ]; 
    }

    public function get_api_params() {
        return [
            'sports_parts' => 'sports_parts',
            '_to_transform_' => [
                'key' => 'date',
                'function' => 'get_date_filter',
                'params' => ['date_type', 'date'],
                'fields_date' => ['date'],
            ],
        ];
    }

    public function get_date_filter($date_type, $date) {
        $array_date = [
            'start' => null
        ];

        if ($date_type == API_DATE_TYPE_YESTERDAY) {
            $array_date['start'] = date('Y-m-d', strtotime("-1 days"));

            return $array_date;
        }

        if ($date_type == API_DATE_TYPE_NOW) {
            $array_date['start'] = date('Y-m-d');

            return $array_date;
        }
        
        if ($date_type == API_DATE_TYPE_TOMORROW) {
            $array_date['start'] = date('Y-m-d',strtotime("+1 days"));
            
            return $array_date;
        }

        if ($date_type == API_DATE_TYPE_RANGE && !empty($date)) {
            $array_date['start'] = $date;

            return $array_date;
        }

        return $array_date;
    }

    public function get_resources($request, $cache_file) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';
        $rdgb_helpers = New Rdg_Blocks_Helpers;

        $sport_information = $rdgb_helpers->get_api_data($this->block_name, $cache_file, $request);

        if (!empty($sport_information->message)) {
            $data->message = $sport_information->message;
        
            return $data;
        }

        $data->json = $sport_information->json;

        return $data;
    }

    public function get_image($url_image, $attributes = []) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $url_image = $rdgb_helpers->get_image_source($url_image, $attributes);

        return $url_image;
    }

    public function get_fields_validate() {
        return [
            //'id_game' => ['required', 'notnull'],
            //'game_date' => ['required', 'notnull'],
            //'sport' => ['required', 'notnull'],
            //'id_visitor_team' => ['required', 'notnull'],
            //'id_master_visitor_team' => ['required', 'notnull'],
            'visitor_team' => ['required', 'notnull'],
            //'visitor_score' => ['required', 'notnull'],
            'visitor_image' => ['required', 'notnull'],
            //'id_home_team' => ['required', 'notnull'],
            //'id_master_home_team' => ['required', 'notnull'],
            'home_team' => ['required', 'notnull'],
            //'home_score' => ['required', 'notnull'],
            'home_image' => ['required', 'notnull'],
            //'game_stat' => ['required', 'notnull'],
            //'category' => ['required', 'notnull'],
            //'league' => ['required', 'notnull'],
            'game_picks_count' => ['required'],
            'game_url' => ['required', 'notnull'],
        ];
    }     
}

add_filter('acf/load_field/name=latest_post', function($field) {
    $categories = get_categories();
    $choices = array();
    foreach ($categories as $category) {
        if ($category->category_parent == 0) {
            // Categoría principal (padre)
            $choices[$category->slug] = $category->name;
        } else {
            // Subcategoría (hijo)
            $parent_category = get_category($category->category_parent);
            $choices[$category->slug] = sprintf('- %s', $category->name);
        }
    }
    $field['choices'] = $choices;
    $field['default_value'] = 'NHL';
    return $field;
});

$rdg_sport_information_class = new Rdg_Blocks_Sport_Information ();
$rdg_sport_information_class->init();

return $rdg_sport_information_class;
