
<?php
    foreach ($sportinfo as $sportdata) {
        $apiDataArray[] = array(
            'sport_external' => $sportdata['sport_external'],        
            'game_date' => $sportdata['game_date'],        
            'visitor_name' => $sportdata['visitor_name'],        
            'home_name' => $sportdata['home_name'],        
            'game_stat' => $sportdata['game_stat'],        
            'num_picks' => $sportdata['num_picks'],        
            'game_url' => $sportdata['game_url'],        
            'visitor_image' => $sportdata['visitor_image'],        
            'home_image' => $sportdata['home_image'],        
            'visitor_image_type' => $sportdata['visitor_image_type'],        
            'home_image_type' => $sportdata['home_image_type'],        
        );
    }
?>

<div class="picks_block">
    <p class="title"><?php echo $picksTitle; ?></p>
    <div class="pick">
        <div class="picks_header">
            <div class="sport">
                <p><?php echo $apiDataArray[0]['sport_external']; ?></p>
            </div>
            <div class="date_time">
                <p><?php echo $apiDataArray[0]['game_date']; ?></p>
            </div>
            <div class="status">
                <p><?php echo $apiDataArray[0]['game_stat']; ?></p>
            </div>
        </div>
        <div class="picks_body">
            <div class="teams">
                <div class="team_a">
                    <img src="<?php echo $apiDataArray[0]['home_image']; ?>" alt="<?php echo $apiDataArray[0]['home_image_type']; ?>">
                    <p><?php echo $apiDataArray[0]['home_name']; ?></p>
                </div>
                <div class="vs_logo">
                    <span>vs</span>
                </div>
                <div class="team_b">
                    <img src="<?php echo $apiDataArray[0]['visitor_image']; ?>" alt="<?php echo $apiDataArray[0]['visitor_image_type']; ?>">
                    <p><?php echo $apiDataArray[0]['visitor_name']; ?></p>
                </div>   
            </div>
        </div>
        <a href="<?php echo $apiDataArray[0]['game_url']; ?>" class="picks_availables">
            <span><?php echo $apiDataArray[0]['num_picks']; ?> PICKS</span>
        </a>
    </div>
</div>

