<?php  
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_SPORT_INFORMATION;
    // $block_classes = [$block_name];
    $block_sport_information = $rdgb->settings->get_block($block_name);

    // Variables
    $blockTitle = get_field('header_title');
    $postBlock = get_field('post_block');
    $handicappersBlock = get_field('handicappers_block');
    $blockFooter = get_field('footer_title');
    $sports_parts = (!empty(get_field('picks_sport'))) ? get_field('picks_sport') : null;

    $message = '';

    $cache_file = null;
    $api_attributes = null;

    $api_url = get_field('pick_vs_api_url', 'option');
    $api_token = get_field('pick_vs_api_token', 'option');
        // $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

    if (!empty($api_url) && !empty($api_token)) {
        $api_attributes = $block_sport_information->get_api_attributes($items, [
            'sports_parts' => $sports_parts
        ]);
        $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
        $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
        $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id_custom, $block_custom_id);
        $response = $block_sport_information->get_resources($api_attributes, $cache_file);

        if (empty($response->message)) {
                $sportinfo = $response->json;
        } else {
                $sportinfo = null;
                $message = $response->message;
        }
    } else {
        $message = __('Configure API connection correctly.');
    }  
    print_r($sportinfo);
?>

<div class="rdg-blocks">
<?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_sport_information->get_log_debug($params);
    ?>
    <div class="rdg-sport-information">
        <div class="si_container">
            <div class="si_header">
                <?php echo $blockTitle; ?>
            </div>
            <div class="si_content">
                <!-- Post Block -->
                <?php if ($postBlock && $postBlock['show_block'] == 'yes'): ?>
                    <?php
                        if ($postBlock['content_source'] == 'latest') {
                            require 'partials/post-block/latest.php';
                        } elseif ($postBlock['content_source'] == 'specific') {
                            require 'partials/post-block/specific.php';
                        } else {
                            require 'partials/post-block/manual.php';
                        }
                    ?>
                <?php endif; ?>

                <!-- Previews Block -->
                <?php if( have_rows('previews_block') ): 
                    while( have_rows('previews_block') ): the_row();
                    $showBlockPreviews = get_sub_field('show_block');
                    $previewsTitle = get_sub_field('block_title');
                    $previewsLink = get_sub_field('previews_link');
                    $recapsLink = get_sub_field('recaps_link');

                    ?>
                    <?php if( $showBlockPreviews == 'yes'): ?>
                        <div class="previews_block">
                            <p class="title"><?php echo $previewsTitle; ?></p>
                            <div class="previews_list">
                            <?php 
                                if( have_rows('vs_list') ):
                                while( have_rows('vs_list') ) : the_row();

                                    $teamA = get_sub_field('team_a');
                                    $teamB = get_sub_field('team_b');
                            ?>
                                <div class="list">
                                    <div class="first-team-name"><?php echo $teamA; ?></div>
                                    <div class="versus">vs.</div>
                                    <div class="second-team-name"><?php echo $teamB; ?></div>
                                </div>

                                <?php endwhile;
                            endif; ?>
                            </div>
                            <div class="previews_links">
                            <?php if (isset( $previewsLink) && !empty( $previewsLink)): ?>
                                <a href="<?php echo $previewsLink['url']; ?>" target="<?php echo $previewsLink['target']; ?>" class="btn"><?php echo $previewsLink['title'] ?></a>
                            </a>
                        <?php endif; ?>
                        <?php if (isset($recapsLink) && !empty($recapsLink)): ?>
                            <a href="<?php echo $recapsLink['url']; ?>" target="<?php echo $recapsLink['target']; ?>" class="btn"><?php echo $recapsLink['title'] ?></a>
                        <?php endif; ?>
                               
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php endwhile; ?>
                <?php endif; ?>

                <!-- Handicappers Block -->
                <?php if( $handicappersBlock ): ?>
                    <?php if( $handicappersBlock['show_block'] == 'yes'): ?>
                        
                        <div class="handicappers_block">
                            <p class="title"><?php echo $handicappersBlock['block_title']; ?></p>
                            <div class="handicappers_container">
                                <div class="handicappers_wrapper">
                                    <div class="handicappers_avatar">
                                        <img src="<?php echo $handicappersBlock['handicapper_logo']['url']; ?>" alt="<?php echo $handicappersBlock['handicapper_logo']['alt']; ?>">
                                    </div>
                                    <div class="handicappers_info">
                                        <p class="title"><?php echo $handicappersBlock['title']; ?></p>
                                        <p class="sub_title"><?php echo $handicappersBlock['subtitle']; ?></p>
                                        <p class="total">
                                            <?php echo $handicappersBlock['total']; ?>
                                            <span class="picks">
                                                <?php echo $handicappersBlock['picks']; ?>
                                            </span>
                                        </p>
                                    </div>
                                </div>
                                <div class="picks_availables">
                                    <span><?php echo $handicappersBlock['picks_availables']; ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Picks Block -->
                <?php if( have_rows('picks_block') ): 
                    while( have_rows('picks_block') ): the_row();
                    $showBlockPicks = get_sub_field('show_block');
                    $source = get_sub_field('source');
                    $picksTitle = get_sub_field('title');
                    $picksCategory = get_sub_field('category');
                    $picksTime = get_sub_field('time');
                    $picksStatus = get_sub_field('status');
                    $picksAvailables = get_sub_field('picks_availables');  ?>
                        <?php if( $showBlockPicks == 'yes'): ?>
                            <?php if (!empty($sportinfo)): ?>
                                <?php
                                    if ($source == 'api') {
                                        require 'partials/picks-vs/api.php';
                                    } else {
                                        require 'partials/picks-vs/manual.php';
                                    }
                                ?>
                            <?php else: ?>
                                <?php if (!empty($message)): ?>
                                    <span class="message"><?php echo $message; ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>  
                    <?php endwhile; ?>
                <?php endif; ?>
            </div>
            <div class="si_footer">
                <?php echo $blockFooter; ?>
            </div>
        </div>
    </div>
</div>
