<?php
global $rdgb;

$key = 'promo_sites_position';
$lastPosition = false;
if ($rdgb->helpers->init_redis()) {
    $lastPosition = $rdgb->helpers->get_redis($key);
}

$promo_sites = get_field('promo_sites');

if ($promo_sites) {
    if ($lastPosition !== false && $lastPosition < count($promo_sites) - 1) {
        $nextPosition = $lastPosition + 1;
    } else {
        $nextPosition = 0;
    }

    $selected_site = $promo_sites[$nextPosition];    
    $rdgb->helpers->set_redis($key, $nextPosition);

    $logo = $selected_site['promote_site_logo'];
    $site_name = $selected_site['promote_site_name'];
    $offer_amount = $selected_site['promote_site_offer_amount'];
    $offer_description = $selected_site['promote_site_offer_description'];
    $button_text = $selected_site['promote_site_button_text'];
    $site_link = $selected_site['promot_site_url'];
    $site_target = $selected_site['promote_site_url_target'];
    $rel_attributes = $selected_site['promote_site_url_attributes'] ?? [];
    $age_terms = $selected_site['promote_site_age_terms'];
    $offer_features = $selected_site['promote_site_offer_features'];
?>
<div class="rdg-blocks">
    <div class="rdg-blocks-promote">
        <div class="header">            
            <div class="promote-left">
            <?php if ($logo): ?>
                    <img class="promote-logo" src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_attr($logo['alt']); ?>" />
                <?php endif; ?>
                <?php if ($site_name): ?>
                    <div class="promote-name"><?php echo esc_html($site_name); ?></div>
                <?php endif; ?>
            </div>
            <div class="promote-right">
                <?php if ($offer_amount): ?>            
                    <span class="promote-offer-amount">$<?php echo esc_html($offer_amount); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <div class="promote-row">
            <div class="promote-content">
                <?php if ($offer_description): ?>
                    <p class="promote-offer-description"><?php echo nl2br(esc_html($offer_description)); ?></p>
                <?php endif; ?>

                <?php if ($site_link): ?>
                    <div class="promote-action-button">                        
                        <a href="<?php echo esc_url($site_link); ?>" 
                            target="<?php echo $site_target; ?>" 
                            rel="<?php echo esc_attr( is_array($rel_attributes) ? implode(' ', $rel_attributes) : $rel_attributes ); ?>"
                        >
                            <?php echo esc_html($button_text); ?>
                        </a>
                    </div>
                <?php endif; ?> 
            </div>
        </div>
        <?php if (!empty($offer_features) && is_array($offer_features)): ?>
            <ul class="promote-features">
                <?php foreach ($offer_features as $feature): ?>
                    <li><span class="feature-text"><?php echo esc_html($feature['promote_site_feature']); ?></span></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
        <?php if ($age_terms): ?>
            <div class="footer">
                <span class="age_terms"><?php echo esc_html($age_terms); ?> </span><span class="terms">Terms & Conditions Apply</span>
            </div>
        <?php endif; ?>
</div>

<?php
} 
?>