<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Experts_Banner extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_EXPERTS_BANNER;
    private $block_folder_name = 'rdg-experts-banner';
    protected $block_title = 'RDG Experts Banner';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'experts banner', 'experts', 'banner'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_experts_banner.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_642ca4a99681b',
                'title' => 'Expert Banner',
                'fields' => array(
                    array(
                        'key' => 'field_642ca4b7e2825',
                        'label' => 'Expert Name',
                        'name' => 'expert_name',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca4efe2826',
                        'label' => 'Expert Category',
                        'name' => 'expert_category',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca503e2827',
                        'label' => 'Expert Img',
                        'name' => 'expert_img',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_642ca51be2828',
                        'label' => 'Win',
                        'name' => 'win',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca7e8e2829',
                        'label' => 'Lose',
                        'name' => 'lose',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca7f0e282a',
                        'label' => 'Push',
                        'name' => 'push',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca7fbe282b',
                        'label' => 'Gain',
                        'name' => 'gain',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca857e282c',
                        'label' => 'Ad',
                        'name' => 'ad',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                        'delay' => 0,
                    ),
                    array(
                        'key' => 'field_642ca865e282d',
                        'label' => 'Button Text',
                        'name' => 'button',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca86de282e',
                        'label' => 'Button Link',
                        'name' => 'button_link',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-experts-banner',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            
            endif;		
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-experts-banner-left','slug' => 'color-rdg-experts-banner-left','color' => '#0160ac'],
            ['name' => 'color-rdg-experts-banner-img-border','slug' => 'color-rdg-experts-banner-img-border','color' => '#ffffff'],
            ['name' => 'color-rdg-experts-banner-description','slug' => 'color-rdg-experts-banner-description','color' => '#ffffff'],
            ['name' => 'color-rdg-experts-banner-right-bg','slug' => 'color-rdg-experts-banner-right-bg','color' => '#F1F1F1'],
            ['name' => 'color-rdg-experts-banner-sponsor','slug' => 'color-rdg-experts-banner-sponsor','color' => '#0160ac'],
            ['name' => 'color-rdg-experts-banner-btn-bg','slug' => 'color-rdg-experts-banner-btn-bg','color' => '#00bc00'],
            ['name' => 'color-rdg-experts-banner-btn-border','slug' => 'color-rdg-experts-banner-btn-border','color' => '#68f96e'],
            ['name' => 'color-rdg-experts-banner-btn-hover','slug' => 'color-rdg-experts-banner-btn-hover','color' => '#244d0e'],
            ['name' => 'color-rdg-experts-banner-link','slug' => 'color-rdg-experts-banner-link','color' => '#ffffff'],

        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-experts-banner .left .description .expert-category',
                'fontWeight' => 'bold',
            ],
            [
                'customSelector' => '.rdg-experts-banner .left .description .expert-name',
                'fontWeight' => 'bold',
                'fontSize' => '1.375rem',
            ],
            [
                'customSelector' => '.rdg-experts-banner .right .odds .accent',
                'fontWeight' => 'bold',
            ],
            [
                'customSelector' => '.rdg-experts-banner .right .sponsor',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.rdg-experts-banner .right .btn',
                'fontWeight' => 'bold',
            ],
            [
                'customSelector' => '.rdg-experts-banner .right a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_experts_banner_class = new Rdg_Blocks_Experts_Banner();
$rdg_experts_banner_class->init();

return $rdg_experts_banner_class;
