<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Login extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_LOGIN;
    private $block_folder_name = 'rdg-login';
    protected $block_title = 'RDG Login';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'login'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        //add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_login.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_paragraph_color_block_dc232ddd2d2d',
                'title' => 'Block_rdg_paragraph_color',
                'fields' => array(
                    array(
                        'key' => 'field_63e25de5bd6b0',
                        'label' => 'Background Image',
                        'name' => 'background_image',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_63e25fc97a807',
                        'label' => 'Content',
                        'name' => 'content',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                        'delay' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-paragraph-color',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-login-box-title','slug' => 'color-rdg-login-box-title','color' => '#ffffff'],
            ['name' => 'color-rdg-login-box-title-bg','slug' => 'color-rdg-login-box-title-bg','color' => '#00bb08'],
            ['name' => 'color-rdg-login-box-body-bg','slug' => 'color-rdg-login-box-body-bg','color' => '#ffffff'],
            ['name' => 'color-rdg-login-box-body-input','slug' => 'color-rdg-login-box-body-input','color' => '#f0f0f0'],
            ['name' => 'color-rdg-login-box-body-text','slug' => 'color-rdg-login-box-body-text','color' => '#111111'],
            ['name' => 'color-rdg-login-box-link-a','slug' => 'color-rdg-login-box-link-a','color' => '#ffffff'],
            ['name' => 'color-rdg-login-box-link-a-bg','slug' => 'color-rdg-login-box-link-a-bg','color' => '#00bb08'],
            ['name' => 'color-rdg-login-box-box-footer-border','slug' => 'color-rdg-login-box-box-footer-border','color' => '#c9c9c9'],
            ['name' => 'color-rdg-login-box-box-footer-a','slug' => 'color-rdg-login-box-box-footer-a','color' => '#808080'],
            ['name' => 'color-rdg-login-box-box-list-bg','slug' => 'color-rdg-login-box-box-list-bg','color' => '#90ee90'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-login .body .box .box-title',
                'fontWeight' => '600',
                'fontSize' => '1.5rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-login .body .box .box-body label',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-login .body .box .box-body .remember',
                'fontWeight' => '600',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-login .body .box .box-body .link a',
                'fontWeight' => '600',
                'fontSize' => '1.2rem',
                'fontSizeTablet' => '1rem',
                'fontSizeMobile' => '0.9rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-login .body .box .box-body .box-footer a',
                'fontWeight' => '600',
                'textDecoration' => 'underline',
            ],
        ];
    }
}

$rdg_login_class = new Rdg_Blocks_Login();
$rdg_login_class->init();

return $rdg_login_class;
