<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Box_List extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BOX_LIST;
    private $block_folder_name = 'rdg-box-list';
    protected $block_title = 'RDG List';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'box', 'list'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        //add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_box_list.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_paragraph_color_block_dc232ddd2d2d',
                'title' => 'Block_rdg_paragraph_color',
                'fields' => array(
                    array(
                        'key' => 'field_63e25de5bd6b0',
                        'label' => 'Background Image',
                        'name' => 'background_image',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_63e25fc97a807',
                        'label' => 'Content',
                        'name' => 'content',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                        'delay' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-paragraph-color',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-box-list-title-bg','slug' => 'color-box-list-title-bg','color' => '#f59c00'],
            ['name' => 'color-box-list-title','slug' => 'color-box-list-title','color' => '#fff'],
            ['name' => 'color-box-list-body-bg','slug' => 'color-box-list-body-bg','color' => '#fff'],
            ['name' => 'color-box-list-content-li','slug' => 'color-box-list-content-li','color' => '#00bb08'],
            ['name' => 'color-box-list-input-bg','slug' => 'color-box-list-input-bg','color' => '#f0f0f0'],
            ['name' => 'color-box-list-content-label','slug' => 'color-box-list-content-label','color' => '#000'],
            ['name' => 'color-box-list-content-remember','slug' => 'color-box-list-content-remember','color' => '#000'],
            ['name' => 'color-box-list-foter-link','slug' => 'color-box-list-foter-link','color' => '#fff'],
            ['name' => 'color-box-list-foter-link-bg','slug' => 'color-box-list-foter-link-bg','color' => '#f59c00'],
            ['name' => 'color-box-list','slug' => 'color-box-list','color' => '90ee90'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-box-list .body .box-register .box-title',
                'fontWeight' => '600',
                'textTransform' => 'uppercase',
                'fontSizeDesktop' => '1.5rem'
            ],
            [
                'customSelector' => '.rdg-box-list .body .box-register .heading',
                'fontSizeDesktop' => '1.3rem',
                'fontWeight' => '600'
            ],
            [
                'customSelector' => '.rdg-box-list .body .box-register .box-content ul li i',
                'fontWeight' => '600'
            ],
            [
                'customSelector' => '.rdg-box-list .body .box-register .box-content label',
                'fontSizeDesktop' => '1rem',
                'fontWeight' => '600'
            ],
            [
                'customSelector' => '.rdg-box-list .body .box-register .box-content .remember',
                'fontSizeDesktop' => '.9rem',
                'fontWeight' => '600'
            ],
            [
                'customSelector' => '.rdg-box-list .body .box-register .box-content .box-footer a',
                'textTransform' => 'uppercase',
                'fontSizeDesktop' => '1.2rem',
                'fontSizeTablet' => '1rem',
                'fontSizeMobile' => '.9rem',
                'fontWeight' => '600'
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-box-list a',
                'textDecoration' => 'none'
            ]
        ];
    }
}

$rdg_box_list_class = new Rdg_Blocks_Box_List();
$rdg_box_list_class->init();

return $rdg_box_list_class;
