<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Consensus extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_CONSENSUS;
    private $block_folder_name = 'rdg-consensus';
    protected $block_title = 'RDG Consensus';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'consensu'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = false;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_consensus.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_consensus_block_adadasd',
                'title' => 'Block_rdg_consensus',
                'fields' => array(
                    array(
                        'key' => 'field_640f65f407e06',
                        'label' => 'Picks',
                        'name' => 'picks',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_640f65f40f826',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_640f65f407e06',
                            ),
                            array(
                                'key' => 'field_640f65f4134db',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 2,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_640f65f42604d',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_640f65f4134db',
                                    ),
                                ),
                                'parent_repeater' => 'field_640f65f407e06',
                            ),
                            array(
                                'key' => 'field_640f65f416ef9',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_640f65f407e06',
                            ),
                            array(
                                'key' => 'field_640f65f41a8ad',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_640f65f407e06',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-consensus',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-consensus-pick-title-color','slug' => 'color-consensus-pick-title-color','color' => '#ffffff'],
            ['name' => 'color-consensus-pick-bg','slug' => 'color-consensus-pick-bg','color' => '#ffffff'],
            ['name' => 'color-consensus-title-bg','slug' => 'color-consensus-title-bg','color' => '#0160ac'],
            ['name' => 'color-consensus-border','slug' => 'color-consensus-border','color' => '#3a96e0'],
            ['name' => 'color-consensus-consensus','slug' => 'color-consensus-consensus','color' => '#eaf6ff'],
            ['name' => 'color-consensus-section-border','slug' => 'color-consensus-section-border','color' => '#CCC'],
            ['name' => 'color-consensus-columns-separate','slug' => 'color-consensus-columns-separate','color' => '#b8d5eb'],
            ['name' => 'color-consensus-footer','slug' => 'color-consensus-footer','color' => '#0160ac'],
            ['name' => 'color-consensus-consensus-text','slug' => 'color-consensus-consensus-text','color' => '#0160ac'],
            ['name' => 'color-consensus-header','slug' => 'color-consensus-header','color' => '#111111'],
            ['name' => 'color-consensus-data','slug' => 'color-consensus-data','color' => '#b2b2be'],
            ['name' => 'color-consensus-data-leyend-title','slug' => 'color-consensus-data-leyend-title','color' => '#111111'],
            ['name' => 'color-consensus-columns-values','slug' => 'color-consensus-columns-values','color' => '#0056a1'],
            ['name' => 'color-consensus-picks','slug' => 'color-consensus-picks','color' => '#0160ac'],
            ['name' => 'color-consensus-picks-color','slug' => 'color-consensus-picks-color','color' => '#00bc00'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [];
    }
}

$rdg_consensus = new Rdg_Blocks_Consensus();
$rdg_consensus->init();

return $rdg_consensus;
